/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collections.pair;

import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.ContainerHelper;
import com.helger.commons.collections.pair.ComparatorPairFirst;
import com.helger.commons.collections.pair.ComparatorPairSecond;
import com.helger.commons.collections.pair.IReadonlyPair;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PairUtils {
    private PairUtils() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <V1 extends Comparable<? super V1>, V2> List<IReadonlyPair<V1, V2>> getSortedByPairFirst(@Nonnull Collection<? extends IReadonlyPair<V1, V2>> collection) {
        return ContainerHelper.getSorted(collection, new ComparatorPairFirst());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <V1, V2 extends Comparable<? super V2>> List<IReadonlyPair<V1, V2>> getSortedByPairSecond(@Nonnull Collection<? extends IReadonlyPair<V1, V2>> collection) {
        return ContainerHelper.getSorted(collection, new ComparatorPairSecond());
    }
}

