/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.idfactory;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.idfactory.IIntIDFactory;
import com.helger.commons.string.ToStringGenerator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnegative;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class AbstractPersistingIntIDFactory
implements IIntIDFactory {
    private final Lock m_aLock = new ReentrantLock();
    private final int m_nReserveCount;
    private int m_nID = 0;
    private int m_nLastID = -1;

    public AbstractPersistingIntIDFactory(@Nonnegative int n) {
        ValueEnforcer.isGT0(n, "ReserveCount");
        this.m_nReserveCount = n;
    }

    @Nonnegative
    public final int getReserveCount() {
        return this.m_nReserveCount;
    }

    protected abstract int readAndUpdateIDCounter(@Nonnegative int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getNewID() {
        this.m_aLock.lock();
        try {
            int n;
            if (this.m_nID >= this.m_nLastID) {
                n = this.readAndUpdateIDCounter(this.m_nReserveCount);
                if (this.m_nLastID >= 0 && n < this.m_nID) {
                    throw new IllegalStateException("The read value " + n + " is smaller than the last known ID " + this.m_nID + "!");
                }
                this.m_nID = n;
                this.m_nLastID = n + this.m_nReserveCount;
            }
            n = this.m_nID++;
            return n;
        }
        finally {
            this.m_aLock.unlock();
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AbstractPersistingIntIDFactory abstractPersistingIntIDFactory = (AbstractPersistingIntIDFactory)object;
        return this.m_nReserveCount == abstractPersistingIntIDFactory.m_nReserveCount && this.m_nID == abstractPersistingIntIDFactory.m_nID;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_nReserveCount).append(this.m_nID).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("reserveCount", this.m_nReserveCount).append("ID", this.m_nID).append("lastID", this.m_nLastID).toString();
    }
}

