/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.idfactory;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.charset.CCharset;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.idfactory.AbstractPersistingIntIDFactory;
import com.helger.commons.io.file.FileUtils;
import com.helger.commons.io.file.SimpleFileIO;
import com.helger.commons.string.StringParser;
import com.helger.commons.string.ToStringGenerator;
import java.io.File;
import java.nio.charset.Charset;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class FileIntIDFactory
extends AbstractPersistingIntIDFactory {
    @Nonnull
    public static final Charset CHARSET_TO_USE = CCharset.CHARSET_ISO_8859_1_OBJ;
    @Nonnegative
    public static final int DEFAULT_RESERVE_COUNT = 20;
    @Nonnull
    private final File m_aFile;

    public FileIntIDFactory(@Nonnull File file) {
        this(file, 20);
    }

    public FileIntIDFactory(@Nonnull File file, @Nonnegative int n) {
        super(n);
        ValueEnforcer.notNull(file, "File");
        if (!FileUtils.canReadAndWriteFile(file)) {
            throw new IllegalArgumentException("Cannot read and/or write the file " + file + "!");
        }
        this.m_aFile = file;
    }

    @Nonnull
    public File getFile() {
        return this.m_aFile;
    }

    @Override
    protected final int readAndUpdateIDCounter(@Nonnegative int n) {
        String string = SimpleFileIO.readFileAsString(this.m_aFile, CHARSET_TO_USE);
        int n2 = string != null ? StringParser.parseInt(string.trim(), 0) : 0;
        SimpleFileIO.writeFile(this.m_aFile, Integer.toString(n2 + n), CHARSET_TO_USE);
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        FileIntIDFactory fileIntIDFactory = (FileIntIDFactory)object;
        return this.m_aFile.equals(fileIntIDFactory.m_aFile);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_aFile).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("file", this.m_aFile).toString();
    }
}

