/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.file.iterate;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.combine.CombinatorStringWithSeparatorIgnoreNull;
import com.helger.commons.filter.IFilter;
import com.helger.commons.io.file.FileUtils;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.tree.withid.folder.DefaultFolderTree;
import com.helger.commons.tree.withid.folder.DefaultFolderTreeItem;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class FileSystemFolderTree
extends DefaultFolderTree<String, File, List<File>> {
    private static void _iterate(@Nonnull DefaultFolderTreeItem<String, File, List<File>> defaultFolderTreeItem, @Nonnull File file, @Nullable IFilter<File> iFilter, @Nullable IFilter<File> iFilter2) {
        if (file != null) {
            for (File file2 : FileUtils.getDirectoryContent(file)) {
                if (file2.isFile()) {
                    if (iFilter2 != null && !iFilter2.matchesFilter(file2)) continue;
                    ((List)defaultFolderTreeItem.getData()).add(file2);
                    continue;
                }
                if (!file2.isDirectory() || FilenameHelper.isSystemInternalDirectory(file2) || iFilter != null && !iFilter.matchesFilter(file2)) continue;
                DefaultFolderTreeItem defaultFolderTreeItem2 = (DefaultFolderTreeItem)defaultFolderTreeItem.createChildItem(file2.getName(), (File)((Object)new ArrayList()));
                FileSystemFolderTree._iterate(defaultFolderTreeItem2, file2, iFilter, iFilter2);
            }
        }
    }

    public FileSystemFolderTree(@Nonnull String string) {
        this(new File(string));
    }

    public FileSystemFolderTree(@Nonnull File file) {
        this(file, (IFilter<File>)null, (IFilter<File>)null);
    }

    public FileSystemFolderTree(@Nonnull String string, @Nullable IFilter<File> iFilter, @Nullable IFilter<File> iFilter2) {
        this(new File(string), iFilter, iFilter2);
    }

    public FileSystemFolderTree(@Nonnull File file, @Nullable IFilter<File> iFilter, @Nullable IFilter<File> iFilter2) {
        super(new CombinatorStringWithSeparatorIgnoreNull("/"));
        ValueEnforcer.notNull(file, "StartDirectory");
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Start directory is not a directory!");
        }
        DefaultFolderTreeItem defaultFolderTreeItem = (DefaultFolderTreeItem)((DefaultFolderTreeItem)this.getRootItem()).createChildItem(file.getName(), new ArrayList());
        FileSystemFolderTree._iterate(defaultFolderTreeItem, file, iFilter, iFilter2);
    }
}

