/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.streamprovider;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.charset.CharsetManager;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.io.IInputStreamAndReaderProvider;
import com.helger.commons.io.IReaderProvider;
import com.helger.commons.io.streams.NonBlockingStringReader;
import com.helger.commons.io.streams.StringInputStream;
import com.helger.commons.serialize.convert.SerializationConverter;
import com.helger.commons.string.ToStringGenerator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class StringInputStreamProvider
implements IInputStreamAndReaderProvider,
IReaderProvider,
Serializable {
    private String m_sData;
    private Charset m_aCharset;

    @Deprecated
    public StringInputStreamProvider(@Nonnull char[] cArray, @Nonnull @Nonempty String string) {
        this(new String(cArray), string);
    }

    public StringInputStreamProvider(@Nonnull char[] cArray, @Nonnull Charset charset) {
        this(new String(cArray), charset);
    }

    @Deprecated
    public StringInputStreamProvider(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull @Nonempty String string) {
        this(new String(cArray, n, n2), string);
    }

    public StringInputStreamProvider(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull Charset charset) {
        this(new String(cArray, n, n2), charset);
    }

    @Deprecated
    public StringInputStreamProvider(@Nonnull CharSequence charSequence, @Nonnull @Nonempty String string) {
        this(charSequence.toString(), string);
    }

    public StringInputStreamProvider(@Nonnull CharSequence charSequence, @Nonnull Charset charset) {
        this(charSequence.toString(), charset);
    }

    @Deprecated
    public StringInputStreamProvider(@Nonnull String string, @Nonnull @Nonempty String string2) {
        this(string, CharsetManager.getCharsetFromName(string2));
    }

    public StringInputStreamProvider(@Nonnull String string, @Nonnull Charset charset) {
        this.m_sData = ValueEnforcer.notNull(string, "Data");
        this.m_aCharset = ValueEnforcer.notNull(charset, "Charset");
    }

    private void writeObject(@Nonnull ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeUTF(this.m_sData);
        SerializationConverter.writeConvertedObject(this.m_aCharset, objectOutputStream);
    }

    private void readObject(@Nonnull ObjectInputStream objectInputStream) throws IOException {
        this.m_sData = objectInputStream.readUTF();
        this.m_aCharset = SerializationConverter.readConvertedObject(objectInputStream, Charset.class);
    }

    @Nonnull
    public String getData() {
        return this.m_sData;
    }

    @Nonnull
    public Charset getCharset() {
        return this.m_aCharset;
    }

    @Override
    @Nonnull
    public final StringInputStream getInputStream() {
        return new StringInputStream(this.m_sData, this.m_aCharset);
    }

    @Override
    @Nonnull
    @Deprecated
    public final NonBlockingStringReader getReader(@Nonnull String string) {
        return new NonBlockingStringReader(this.m_sData);
    }

    @Override
    @Nonnull
    public final NonBlockingStringReader getReader(@Nonnull Charset charset) {
        return new NonBlockingStringReader(this.m_sData);
    }

    @Override
    @Nonnull
    public final NonBlockingStringReader getReader() {
        return new NonBlockingStringReader(this.m_sData);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        StringInputStreamProvider stringInputStreamProvider = (StringInputStreamProvider)object;
        return this.m_sData.equals(stringInputStreamProvider.m_sData) && this.m_aCharset.equals(stringInputStreamProvider.m_aCharset);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sData).append(this.m_aCharset).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("data", this.m_sData).append("charset", this.m_aCharset).toString();
    }
}

