/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.streams;

import com.helger.commons.stats.IStatisticsHandlerCounter;
import com.helger.commons.stats.IStatisticsHandlerSize;
import com.helger.commons.stats.StatisticsManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.annotation.Nonnull;

public class CountingFileInputStream
extends FileInputStream {
    private static final IStatisticsHandlerSize s_aReadSizeHdl = StatisticsManager.getSizeHandler(CountingFileInputStream.class.getName() + "$read.bytes");
    private static final IStatisticsHandlerCounter s_aReadFilesHdl = StatisticsManager.getCounterHandler(CountingFileInputStream.class.getName() + "$read.files");

    public CountingFileInputStream(@Nonnull File file) throws FileNotFoundException {
        super(file);
        s_aReadFilesHdl.increment();
    }

    public CountingFileInputStream(@Nonnull String string) throws FileNotFoundException {
        super(string);
        s_aReadFilesHdl.increment();
    }

    @Override
    public int read() throws IOException {
        int n = super.read();
        if (n != -1) {
            s_aReadSizeHdl.addSize(1L);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n = super.read(byArray);
        if (n > -1) {
            s_aReadSizeHdl.addSize(n);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 > -1) {
            s_aReadSizeHdl.addSize(n3);
        }
        return n3;
    }
}

