/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.log;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.error.EErrorLevel;
import com.helger.commons.error.IHasErrorLevel;
import com.helger.commons.error.ISeverityComparable;
import com.helger.commons.state.IErrorIndicator;
import com.helger.commons.state.ISuccessIndicator;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class LogMessage
implements IHasErrorLevel,
ISuccessIndicator,
IErrorIndicator,
ISeverityComparable<LogMessage>,
Serializable {
    private final Date m_aIssueDT = new Date();
    private final EErrorLevel m_eErrorLevel;
    private final Serializable m_aMsg;
    private final Throwable m_aThrowable;

    public LogMessage(@Nonnull EErrorLevel eErrorLevel, @Nonnull Serializable serializable, @Nullable Throwable throwable) {
        this.m_eErrorLevel = ValueEnforcer.notNull(eErrorLevel, "ErrorLevel");
        this.m_aMsg = ValueEnforcer.notNull(serializable, "Message");
        this.m_aThrowable = throwable;
    }

    @Nonnull
    @ReturnsMutableCopy
    public Date getIssueDateTime() {
        return (Date)this.m_aIssueDT.clone();
    }

    @Override
    @Nonnull
    public EErrorLevel getErrorLevel() {
        return this.m_eErrorLevel;
    }

    @Nonnull
    public Serializable getMessage() {
        return this.m_aMsg;
    }

    @Nullable
    public Throwable getThrowable() {
        return this.m_aThrowable;
    }

    @Override
    public boolean isSuccess() {
        return this.m_eErrorLevel.isSuccess();
    }

    @Override
    public boolean isFailure() {
        return this.m_eErrorLevel.isFailure();
    }

    @Override
    public boolean isError() {
        return this.m_eErrorLevel.isError();
    }

    @Override
    public boolean isNoError() {
        return this.m_eErrorLevel.isNoError();
    }

    @Override
    public boolean isEqualSevereThan(@Nonnull LogMessage logMessage) {
        return this.m_eErrorLevel.isEqualSevereThan(logMessage.m_eErrorLevel);
    }

    @Override
    public boolean isLessSevereThan(@Nonnull LogMessage logMessage) {
        return this.m_eErrorLevel.isLessSevereThan(logMessage.m_eErrorLevel);
    }

    @Override
    public boolean isLessOrEqualSevereThan(@Nonnull LogMessage logMessage) {
        return this.m_eErrorLevel.isLessOrEqualSevereThan(logMessage.m_eErrorLevel);
    }

    @Override
    public boolean isMoreSevereThan(@Nonnull LogMessage logMessage) {
        return this.m_eErrorLevel.isMoreSevereThan(logMessage.m_eErrorLevel);
    }

    @Override
    public boolean isMoreOrEqualSevereThan(@Nonnull LogMessage logMessage) {
        return this.m_eErrorLevel.isMoreOrEqualSevereThan(logMessage.m_eErrorLevel);
    }

    public String toString() {
        return new ToStringGenerator(this).append("issueDT", this.m_aIssueDT).append("errorLevel", this.m_eErrorLevel).append("msg", this.m_aMsg).appendIfNotNull("throwable", this.m_aThrowable).toString();
    }
}

