/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.microdom.utils;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.microdom.IMicroElement;
import com.helger.commons.parent.IChildrenProvider;
import com.helger.commons.string.StringHelper;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ChildrenProviderElementWithName
implements IChildrenProvider<IMicroElement> {
    private final String m_sNamespaceURI;
    private final String m_sTagName;

    public ChildrenProviderElementWithName(@Nonnull @Nonempty String string) {
        this(null, string);
    }

    public ChildrenProviderElementWithName(@Nullable String string, @Nonnull @Nonempty String string2) {
        this.m_sNamespaceURI = string;
        this.m_sTagName = ValueEnforcer.notEmpty(string2, "TagName");
    }

    @Override
    public boolean hasChildren(@Nullable IMicroElement iMicroElement) {
        if (iMicroElement == null || !iMicroElement.isElement()) {
            return false;
        }
        if (StringHelper.hasText(this.m_sNamespaceURI)) {
            return iMicroElement.hasChildElements(this.m_sNamespaceURI, this.m_sTagName);
        }
        return iMicroElement.hasChildElements(this.m_sTagName);
    }

    @Override
    @Nonnegative
    public int getChildCount(@Nullable IMicroElement iMicroElement) {
        return iMicroElement == null ? 0 : this.getChildren(iMicroElement).size();
    }

    @Override
    @Nonnull
    @Deprecated
    @ReturnsMutableCopy
    public Collection<? extends IMicroElement> getChildren(@Nullable IMicroElement iMicroElement) {
        return this.getAllChildren(iMicroElement);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Collection<? extends IMicroElement> getAllChildren(@Nullable IMicroElement iMicroElement) {
        if (iMicroElement == null) {
            return new ArrayList();
        }
        if (StringHelper.hasText(this.m_sNamespaceURI)) {
            return iMicroElement.getAllChildElements(this.m_sNamespaceURI, this.m_sTagName);
        }
        return iMicroElement.getAllChildElements(this.m_sTagName);
    }
}

