/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.mock;

import com.helger.commons.ICloneable;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.callback.AdapterRunnableToThrowingRunnable;
import com.helger.commons.callback.IThrowingRunnable;
import com.helger.commons.charset.CCharset;
import com.helger.commons.concurrent.ManagedExecutorService;
import com.helger.commons.equals.EqualsUtils;
import com.helger.commons.io.file.FileUtils;
import com.helger.commons.io.file.iterate.FileSystemIterator;
import com.helger.commons.io.streamprovider.ByteArrayInputStreamProvider;
import com.helger.commons.io.streams.NonBlockingBufferedReader;
import com.helger.commons.io.streams.NonBlockingByteArrayOutputStream;
import com.helger.commons.io.streams.StreamUtils;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.lang.StackTraceHelper;
import com.helger.commons.microdom.IMicroElement;
import com.helger.commons.microdom.convert.MicroTypeConverter;
import com.helger.commons.microdom.serialize.MicroWriter;
import com.helger.commons.string.StringHelper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class PHTestUtils {
    private static final Logger s_aLogger = LoggerFactory.getLogger(PHTestUtils.class);
    private static final PHTestUtils s_aInstance = new PHTestUtils();

    private PHTestUtils() {
    }

    private static void _assertTrue(@Nonnull String string, boolean bl) {
        if (!bl) {
            throw new IllegalStateException(string);
        }
    }

    private static void _assertFalse(@Nonnull String string, boolean bl) {
        if (bl) {
            throw new IllegalStateException(string);
        }
    }

    private static void _assertNotNull(@Nonnull String string, Object object) {
        if (object == null) {
            throw new IllegalStateException(string);
        }
    }

    private static <T> void _assertEquals(@Nonnull String string, @Nullable T t, @Nullable T t2) {
        if (!EqualsUtils.equals(t, t2)) {
            throw new IllegalStateException(string + "\nOBJ1: " + t + "\nOBJ2: " + t2);
        }
    }

    @SuppressFBWarnings(value={"EC_NULL_ARG"})
    private static <DATATYPE> void _testEqualsImplementation(@Nonnull DATATYPE DATATYPE) {
        PHTestUtils._assertNotNull("Passed object may not be null!", DATATYPE);
        PHTestUtils._assertTrue("Passed objects are not equal", DATATYPE.equals(DATATYPE));
        PHTestUtils._assertFalse("Object may no be equal to String", DATATYPE.equals("any string"));
        PHTestUtils._assertFalse("Object may no be equal to null", DATATYPE.equals(null));
    }

    private static <DATATYPE> void _testEqualsImplementationWithEqualContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        PHTestUtils._testEqualsImplementation(DATATYPE);
        PHTestUtils._testEqualsImplementation(DATATYPE2);
        PHTestUtils._assertFalse("This test may not be used with the same object!", DATATYPE == DATATYPE2);
        PHTestUtils._assertTrue("Passed objects are not identical!", DATATYPE.equals(DATATYPE2));
        PHTestUtils._assertTrue("Passed objects are not identical!", DATATYPE2.equals(DATATYPE));
    }

    private static <DATATYPE> void _testEqualsImplementationWithDifferentContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        PHTestUtils._testEqualsImplementation(DATATYPE);
        PHTestUtils._testEqualsImplementation(DATATYPE2);
        PHTestUtils._assertFalse("This test may not be used with the same object!", DATATYPE == DATATYPE2);
        PHTestUtils._assertFalse("Passed objects are identical!", DATATYPE.equals(DATATYPE2));
        PHTestUtils._assertFalse("Passed objects are identical!", DATATYPE2.equals(DATATYPE));
    }

    private static <DATATYPE> void _testHashcodeImplementation(@Nonnull DATATYPE DATATYPE) {
        PHTestUtils._assertNotNull("Passed object may not be null!", DATATYPE);
        PHTestUtils._assertTrue("hashCode() invocations must be consistent", DATATYPE.hashCode() == DATATYPE.hashCode());
        PHTestUtils._assertFalse("hashCode() may not be 0", DATATYPE.hashCode() == 0);
    }

    private static <DATATYPE> void _testHashcodeImplementationWithEqualContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        PHTestUtils._testHashcodeImplementation(DATATYPE);
        PHTestUtils._testHashcodeImplementation(DATATYPE2);
        PHTestUtils._assertTrue("Passed objects are not identical!", DATATYPE.equals(DATATYPE2));
        PHTestUtils._assertFalse("This test may not be used with the same object!", DATATYPE == DATATYPE2);
        PHTestUtils._assertTrue("hashCode() invocations must be consistent", DATATYPE.hashCode() == DATATYPE2.hashCode());
        PHTestUtils._assertTrue("hashCode() invocations must be consistent", DATATYPE2.hashCode() == DATATYPE.hashCode());
    }

    private static <DATATYPE> void _testHashcodeImplementationWithDifferentContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        PHTestUtils._testHashcodeImplementation(DATATYPE);
        PHTestUtils._testHashcodeImplementation(DATATYPE2);
        PHTestUtils._assertFalse("Passed objects are identical!", DATATYPE.equals(DATATYPE2));
        PHTestUtils._assertFalse("This test may not be used with the same object!", DATATYPE == DATATYPE2);
        int n = DATATYPE.hashCode();
        int n2 = DATATYPE2.hashCode();
        PHTestUtils._assertFalse("hashCode() may not be the same for both objects", n == n2);
    }

    public static <DATATYPE> void testToStringImplementation(@Nonnull DATATYPE DATATYPE) {
        PHTestUtils._assertNotNull("Passed object may not be null!", DATATYPE);
        PHTestUtils._assertNotNull("toString() may not return null!", DATATYPE.toString());
        PHTestUtils._assertTrue("toString() may not return an empty string!", DATATYPE.toString().length() > 0);
        PHTestUtils._assertTrue("toString() invocations must be consistent", DATATYPE.toString().equals(DATATYPE.toString()));
    }

    private static <DATATYPE> void _testToStringImplementationWithEqualContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        PHTestUtils.testToStringImplementation(DATATYPE);
        PHTestUtils.testToStringImplementation(DATATYPE2);
        PHTestUtils._assertTrue("Passed objects are not identical!", DATATYPE.equals(DATATYPE2));
        PHTestUtils._assertFalse("This test may not be used with the same object!", DATATYPE == DATATYPE2);
    }

    private static <DATATYPE> void _testToStringImplementationWithDifferentContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        PHTestUtils.testToStringImplementation(DATATYPE);
        PHTestUtils.testToStringImplementation(DATATYPE2);
        PHTestUtils._assertFalse("Passed objects are identical!", DATATYPE.equals(DATATYPE2));
        PHTestUtils._assertFalse("This test may not be used with the same object!", DATATYPE == DATATYPE2);
    }

    public static <DATATYPE> void testDefaultImplementationWithEqualContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        PHTestUtils._testEqualsImplementationWithEqualContentObject(DATATYPE, DATATYPE2);
        PHTestUtils._testHashcodeImplementationWithEqualContentObject(DATATYPE, DATATYPE2);
        PHTestUtils._testToStringImplementationWithEqualContentObject(DATATYPE, DATATYPE2);
    }

    public static <DATATYPE> void testDefaultImplementationWithDifferentContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        PHTestUtils._testEqualsImplementationWithDifferentContentObject(DATATYPE, DATATYPE2);
        PHTestUtils._testHashcodeImplementationWithDifferentContentObject(DATATYPE, DATATYPE2);
        PHTestUtils._testToStringImplementationWithDifferentContentObject(DATATYPE, DATATYPE2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static <DATATYPE extends Serializable> DATATYPE testDefaultSerialization(@Nonnull DATATYPE DATATYPE) {
        try {
            Serializable serializable;
            NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(nonBlockingByteArrayOutputStream);
            try {
                objectOutputStream.writeObject(DATATYPE);
            }
            finally {
                StreamUtils.close(objectOutputStream);
            }
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStreamProvider(nonBlockingByteArrayOutputStream.toByteArray()).getInputStream());
            try {
                serializable = (Serializable)GenericReflection.uncheckedCast(objectInputStream.readObject());
            }
            finally {
                StreamUtils.close(objectInputStream);
            }
            PHTestUtils.testDefaultImplementationWithEqualContentObject(DATATYPE, serializable);
            return (DATATYPE)serializable;
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("testDefaultSerialization failed", throwable);
        }
    }

    public static void testGetClone(@Nonnull ICloneable<?> iCloneable) {
        Object obj = iCloneable.getClone();
        PHTestUtils._assertNotNull("Clone returned a null object", obj);
        PHTestUtils._assertTrue("Clone returned a different class than the original one", obj.getClass().equals(iCloneable.getClass()));
        PHTestUtils.testDefaultImplementationWithEqualContentObject(iCloneable, obj);
    }

    public static void testMicroTypeConversion(@Nonnull Object object) {
        Assert.assertNotNull((Object)object);
        IMicroElement iMicroElement = MicroTypeConverter.convertToMicroElement(object, "test");
        Assert.assertNotNull((Object)iMicroElement);
        Object obj = MicroTypeConverter.convertToNative(iMicroElement, object.getClass());
        Assert.assertNotNull(obj);
        IMicroElement iMicroElement2 = MicroTypeConverter.convertToMicroElement(obj, "test");
        Assert.assertNotNull((Object)iMicroElement2);
        String string = MicroWriter.getXMLString(iMicroElement);
        String string2 = MicroWriter.getXMLString(iMicroElement2);
        PHTestUtils._assertEquals("XML representation must be identical", string, string2);
        PHTestUtils.testDefaultImplementationWithEqualContentObject(object, obj);
    }

    public static void testInParallel(@Nonnegative int n, @Nonnull Runnable runnable) {
        ValueEnforcer.notNull(runnable, "Runnable");
        PHTestUtils.testInParallel(n, new AdapterRunnableToThrowingRunnable(runnable));
    }

    public static void testInParallel(@Nonnegative int n, final @Nonnull IThrowingRunnable iThrowingRunnable) {
        ValueEnforcer.isGE0(n, "Calls");
        ValueEnforcer.notNull(iThrowingRunnable, "Runnable");
        ExecutorService executorService = Executors.newFixedThreadPool(20);
        final ArrayList arrayList = new ArrayList();
        for (int i = 0; i < n; ++i) {
            executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        iThrowingRunnable.run();
                    }
                    catch (Throwable throwable) {
                        arrayList.add(throwable.getMessage() + "\n" + StackTraceHelper.getStackAsString(throwable));
                    }
                }
            });
        }
        ManagedExecutorService.shutdownAndWaitUntilAllTasksAreFinished(executorService);
        if (!arrayList.isEmpty()) {
            throw new IllegalStateException(StringHelper.getImploded(arrayList));
        }
    }

    @Nonnegative
    public static int testIfAllSPIFilesAreValid(@Nonnull String string) throws Exception {
        int n = 0;
        File file = new File(string);
        if (file.exists() && file.isDirectory()) {
            for (File file2 : new FileSystemIterator(string)) {
                if (!file2.isFile()) continue;
                s_aLogger.info("Checking SPI file " + file2.getAbsolutePath());
                NonBlockingBufferedReader nonBlockingBufferedReader = new NonBlockingBufferedReader(StreamUtils.createReader(FileUtils.getInputStream(file2), CCharset.CHARSET_SERVICE_LOADER_OBJ));
                try {
                    String string2;
                    int n2 = 0;
                    while ((string2 = nonBlockingBufferedReader.readLine()) != null) {
                        String string3 = StringHelper.trim(string2);
                        if (!StringHelper.hasText(string3)) continue;
                        Class.forName(string2);
                        ++n2;
                        ++n;
                    }
                    if (n2 == 0) {
                        s_aLogger.warn("  Contains no single valid implementation!");
                        continue;
                    }
                    s_aLogger.info("  All implementations (" + n2 + ") are valid!");
                }
                catch (Throwable throwable) {
                    throw new Exception("Error checking SPI file " + file2.getAbsolutePath(), throwable);
                }
                finally {
                    StreamUtils.close(nonBlockingBufferedReader);
                }
            }
        }
        return n;
    }

    @Nonnegative
    public static int testIfAllSPIImplementationsAreValid() throws Exception {
        int n = 0;
        n += PHTestUtils.testIfAllSPIFilesAreValid("src/main/resources/META-INF/services");
        return n += PHTestUtils.testIfAllSPIFilesAreValid("src/test/resources/META-INF/services");
    }
}

