/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.mutable;

import com.helger.commons.CGlobal;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.equals.EqualsUtils;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.math.MathHelper;
import com.helger.commons.mutable.IMutableNumeric;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import java.math.BigDecimal;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class MutableBigDecimal
extends Number
implements IMutableNumeric<MutableBigDecimal> {
    public static final BigDecimal DEFAULT_VALUE = BigDecimal.ZERO;
    private BigDecimal m_aValue;

    public MutableBigDecimal() {
        this(DEFAULT_VALUE);
    }

    public MutableBigDecimal(@Nonnull BigDecimal bigDecimal) {
        this.m_aValue = ValueEnforcer.notNull(bigDecimal, "Value");
    }

    @Nonnull
    public BigDecimal getAsBigDecimal() {
        return this.m_aValue;
    }

    @Override
    public double doubleValue() {
        return this.m_aValue.doubleValue();
    }

    @Nonnull
    public Double getAsDouble() {
        return this.doubleValue();
    }

    @Override
    public float floatValue() {
        return this.m_aValue.floatValue();
    }

    @Override
    public int intValue() {
        return this.m_aValue.intValue();
    }

    @Override
    public long longValue() {
        return this.m_aValue.longValue();
    }

    @Nonnull
    public BigDecimal inc() {
        return this.inc(BigDecimal.ONE);
    }

    @Nonnull
    public BigDecimal inc(@Nonnull BigDecimal bigDecimal) {
        this.m_aValue = this.m_aValue.add(bigDecimal);
        return this.m_aValue;
    }

    @Nonnull
    public BigDecimal dec() {
        return this.inc(CGlobal.BIGDEC_MINUS_ONE);
    }

    @Nonnull
    public BigDecimal dec(@Nonnull BigDecimal bigDecimal) {
        return this.inc(bigDecimal.negate());
    }

    @Nonnull
    public EChange set(@Nonnull BigDecimal bigDecimal) {
        if (EqualsUtils.equals(bigDecimal, this.m_aValue)) {
            return EChange.UNCHANGED;
        }
        this.m_aValue = bigDecimal;
        return EChange.CHANGED;
    }

    @Override
    public boolean is0() {
        return MathHelper.isEqualToZero(this.m_aValue);
    }

    @Override
    public boolean isNot0() {
        return MathHelper.isNotEqualToZero(this.m_aValue);
    }

    @Override
    public boolean isSmaller0() {
        return MathHelper.isLowerThanZero(this.m_aValue);
    }

    @Override
    public boolean isSmallerOrEqual0() {
        return MathHelper.isLowerOrEqualThanZero(this.m_aValue);
    }

    @Override
    public boolean isGreater0() {
        return MathHelper.isGreaterThanZero(this.m_aValue);
    }

    @Override
    public boolean isGreaterOrEqual0() {
        return MathHelper.isGreaterOrEqualThanZero(this.m_aValue);
    }

    @Override
    public int compareTo(@Nonnull MutableBigDecimal mutableBigDecimal) {
        return this.m_aValue.compareTo(mutableBigDecimal.m_aValue);
    }

    @Override
    @Nonnull
    public MutableBigDecimal getClone() {
        return new MutableBigDecimal(this.m_aValue);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MutableBigDecimal mutableBigDecimal = (MutableBigDecimal)object;
        return EqualsUtils.equals(this.m_aValue, mutableBigDecimal.m_aValue);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("value", this.m_aValue).toString();
    }
}

