/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.callback;

import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.callback.IExceptionHandler;
import com.helger.commons.collections.ContainerHelper;
import com.helger.commons.string.ToStringGenerator;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class CollectingExceptionHandlerMultiple<EXTYPE extends Throwable>
implements IExceptionHandler<EXTYPE> {
    private final List<EXTYPE> m_aExceptions = new ArrayList<EXTYPE>();

    @Override
    public void onException(@Nullable EXTYPE EXTYPE) {
        if (EXTYPE != null) {
            this.m_aExceptions.add(EXTYPE);
        }
    }

    public boolean hasException() {
        return !this.m_aExceptions.isEmpty();
    }

    @Nonnegative
    public int getExceptionCount() {
        return this.m_aExceptions.size();
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<EXTYPE> getAllExceptions() {
        return ContainerHelper.newList(this.m_aExceptions);
    }

    public String toString() {
        return new ToStringGenerator(this).append("exceptions", this.m_aExceptions).toString();
    }
}

