/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collections;

import com.helger.commons.equals.EqualsUtils;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class SingleMapEntry<KEYTYPE, VALUETYPE>
implements Map.Entry<KEYTYPE, VALUETYPE> {
    private final KEYTYPE m_aKey;
    private VALUETYPE m_aValue;

    public SingleMapEntry(@Nullable KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE) {
        this.m_aKey = KEYTYPE;
        this.m_aValue = VALUETYPE;
    }

    @Override
    @Nullable
    public KEYTYPE getKey() {
        return this.m_aKey;
    }

    @Override
    @Nullable
    public VALUETYPE getValue() {
        return this.m_aValue;
    }

    @Override
    @Nullable
    public VALUETYPE setValue(@Nullable VALUETYPE VALUETYPE) {
        VALUETYPE VALUETYPE2 = this.m_aValue;
        this.m_aValue = VALUETYPE;
        return VALUETYPE2;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        SingleMapEntry singleMapEntry = (SingleMapEntry)object;
        return EqualsUtils.equals(this.m_aKey, singleMapEntry.m_aKey) && EqualsUtils.equals(this.m_aValue, singleMapEntry.m_aValue);
    }

    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aKey).append(this.m_aValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("key", this.m_aKey).append("value", this.m_aValue).toString();
    }
}

