/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collections.attrs;

import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.attrs.IGenericReadonlyAttributeContainer;
import com.helger.commons.collections.attrs.MapBasedGenericAttributeContainer;
import com.helger.commons.state.EChange;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class MapBasedGenericAttributeContainerThreadSafe<KEYTYPE, VALUETYPE>
extends MapBasedGenericAttributeContainer<KEYTYPE, VALUETYPE> {
    protected final ReadWriteLock m_aRWLock = new ReentrantReadWriteLock();

    public MapBasedGenericAttributeContainerThreadSafe() {
    }

    public MapBasedGenericAttributeContainerThreadSafe(@Nonnull Map<? extends KEYTYPE, ? extends VALUETYPE> map) {
        super(map);
    }

    public MapBasedGenericAttributeContainerThreadSafe(@Nonnull IGenericReadonlyAttributeContainer<? extends KEYTYPE, ? extends VALUETYPE> iGenericReadonlyAttributeContainer) {
        super(iGenericReadonlyAttributeContainer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAttribute(@Nullable KEYTYPE KEYTYPE) {
        this.m_aRWLock.readLock().lock();
        try {
            boolean bl = super.containsAttribute(KEYTYPE);
            return bl;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Map<KEYTYPE, VALUETYPE> getAllAttributes() {
        this.m_aRWLock.readLock().lock();
        try {
            Map map = super.getAllAttributes();
            return map;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public VALUETYPE getAttributeObject(@Nullable KEYTYPE KEYTYPE) {
        this.m_aRWLock.readLock().lock();
        try {
            Object VALUETYPE = super.getAttributeObject(KEYTYPE);
            return VALUETYPE;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange setAttribute(@Nonnull KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE) {
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = super.setAttribute(KEYTYPE, VALUETYPE);
            return eChange;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange removeAttribute(@Nullable KEYTYPE KEYTYPE) {
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = super.removeAttribute(KEYTYPE);
            return eChange;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Enumeration<KEYTYPE> getAttributeNames() {
        this.m_aRWLock.readLock().lock();
        try {
            Enumeration enumeration = super.getAttributeNames();
            return enumeration;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Set<KEYTYPE> getAllAttributeNames() {
        this.m_aRWLock.readLock().lock();
        try {
            Set set = super.getAllAttributeNames();
            return set;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Collection<VALUETYPE> getAllAttributeValues() {
        this.m_aRWLock.readLock().lock();
        try {
            Collection collection = super.getAllAttributeValues();
            return collection;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnegative
    public int getAttributeCount() {
        this.m_aRWLock.readLock().lock();
        try {
            int n = super.getAttributeCount();
            return n;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsNoAttribute() {
        this.m_aRWLock.readLock().lock();
        try {
            boolean bl = super.containsNoAttribute();
            return bl;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange clear() {
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = super.clear();
            return eChange;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    @Override
    @Nonnull
    public MapBasedGenericAttributeContainerThreadSafe<KEYTYPE, VALUETYPE> getClone() {
        return new MapBasedGenericAttributeContainerThreadSafe<KEYTYPE, VALUETYPE>(this);
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

