/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collections.iterate;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collections.ArrayHelper;
import com.helger.commons.equals.EqualsUtils;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.util.Arrays;
import java.util.NoSuchElementException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class ArrayIteratorByte {
    private final byte[] m_aArray;
    private int m_nIndex;

    public ArrayIteratorByte(byte ... byArray) {
        ValueEnforcer.notNull(byArray, "Array");
        this.m_nIndex = 0;
        this.m_aArray = ArrayHelper.getCopy(byArray);
    }

    private ArrayIteratorByte(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isArrayOfsLen(byArray, n, n2);
        this.m_nIndex = 0;
        this.m_aArray = ArrayHelper.getCopy(byArray, n, n2);
    }

    public boolean hasNext() {
        return this.m_nIndex < this.m_aArray.length;
    }

    public byte next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.m_aArray[this.m_nIndex++];
    }

    @Deprecated
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ArrayIteratorByte arrayIteratorByte = (ArrayIteratorByte)object;
        return EqualsUtils.equals(this.m_aArray, arrayIteratorByte.m_aArray) && this.m_nIndex == arrayIteratorByte.m_nIndex;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aArray).append(this.m_nIndex).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("array", Arrays.toString(this.m_aArray)).append("index", this.m_nIndex).toString();
    }

    @Nonnull
    public static ArrayIteratorByte createOfsLen(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        return new ArrayIteratorByte(byArray, n, n2);
    }

    @Nonnull
    public static ArrayIteratorByte createBeginEnd(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        if (n2 < n) {
            throw new IllegalArgumentException("Begin (" + n + ") must be between 0 and < end (" + n2 + ")");
        }
        return ArrayIteratorByte.createOfsLen(byArray, n, n2 - n);
    }
}

