/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.error;

import com.helger.commons.annotations.Nonempty;
import com.helger.commons.error.ISeverityComparable;
import com.helger.commons.id.IHasID;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.state.IErrorIndicator;
import com.helger.commons.state.ISuccessIndicator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EErrorLevel implements IHasID<String>,
ISuccessIndicator,
IErrorIndicator,
ISeverityComparable<EErrorLevel>
{
    SUCCESS("success", 0),
    INFO("info", 100),
    WARN("warn", 200),
    ERROR("error", 300),
    FATAL_ERROR("fatal_error", 400);

    public static final EErrorLevel LOWEST;
    public static final EErrorLevel HIGHEST;
    private final String m_sID;
    private final int m_nNumericLevel;

    private EErrorLevel(String string2, int n2) {
        this.m_sID = string2;
        this.m_nNumericLevel = n2;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Override
    public boolean isSuccess() {
        return this == SUCCESS;
    }

    @Override
    public boolean isFailure() {
        return this != SUCCESS;
    }

    @Override
    public boolean isError() {
        return this.isMoreOrEqualSevereThan(ERROR);
    }

    @Override
    public boolean isNoError() {
        return this.isLessSevereThan(ERROR);
    }

    @Nonnegative
    public int getNumericLevel() {
        return this.m_nNumericLevel;
    }

    @Override
    public boolean isEqualSevereThan(@Nonnull EErrorLevel eErrorLevel) {
        return this.getNumericLevel() == eErrorLevel.getNumericLevel();
    }

    @Override
    public boolean isLessSevereThan(@Nonnull EErrorLevel eErrorLevel) {
        return this.getNumericLevel() < eErrorLevel.getNumericLevel();
    }

    @Override
    public boolean isLessOrEqualSevereThan(@Nonnull EErrorLevel eErrorLevel) {
        return this.getNumericLevel() <= eErrorLevel.getNumericLevel();
    }

    @Override
    public boolean isMoreSevereThan(@Nonnull EErrorLevel eErrorLevel) {
        return this.getNumericLevel() > eErrorLevel.getNumericLevel();
    }

    @Override
    public boolean isMoreOrEqualSevereThan(@Nonnull EErrorLevel eErrorLevel) {
        return this.getNumericLevel() >= eErrorLevel.getNumericLevel();
    }

    @Nullable
    public static EErrorLevel getMostSevere(@Nullable EErrorLevel eErrorLevel, @Nullable EErrorLevel eErrorLevel2) {
        if (eErrorLevel == eErrorLevel2) {
            return eErrorLevel;
        }
        if (eErrorLevel == null) {
            return eErrorLevel2;
        }
        if (eErrorLevel2 == null) {
            return eErrorLevel;
        }
        return eErrorLevel.isMoreSevereThan(eErrorLevel2) ? eErrorLevel : eErrorLevel2;
    }

    @Nullable
    public static EErrorLevel getFromIDOrNull(@Nullable String string) {
        return EnumHelper.getFromIDOrNull(EErrorLevel.class, string);
    }

    @Nonnull
    public static EErrorLevel getFromIDOrThrow(@Nullable String string) {
        return EnumHelper.getFromIDOrThrow(EErrorLevel.class, string);
    }

    @Nullable
    public static EErrorLevel getFromIDOrDefault(@Nullable String string, @Nullable EErrorLevel eErrorLevel) {
        return EnumHelper.getFromIDOrDefault(EErrorLevel.class, string, eErrorLevel);
    }

    @Nullable
    public static EErrorLevel getFromIDCaseInsensitiveOrNull(@Nullable String string) {
        return EnumHelper.getFromIDCaseInsensitiveOrNull(EErrorLevel.class, string);
    }

    @Nonnull
    public static EErrorLevel getFromIDCaseInsensitiveOrThrow(@Nullable String string) {
        return EnumHelper.getFromIDCaseInsensitiveOrThrow(EErrorLevel.class, string);
    }

    @Nullable
    public static EErrorLevel getFromIDCaseInsensitiveOrDefault(@Nullable String string, @Nullable EErrorLevel eErrorLevel) {
        return EnumHelper.getFromIDCaseInsensitiveOrDefault(EErrorLevel.class, string, eErrorLevel);
    }

    static {
        LOWEST = SUCCESS;
        HIGHEST = FATAL_ERROR;
    }
}

