/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.gfx;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.math.IHasWidthAndHeight;
import com.helger.commons.math.MathHelper;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ScalableSize
implements IHasWidthAndHeight,
Serializable {
    private final int m_nWidth;
    private final int m_nHeight;

    public ScalableSize(@Nonnull IHasWidthAndHeight iHasWidthAndHeight) {
        this(iHasWidthAndHeight.getWidth(), iHasWidthAndHeight.getHeight());
    }

    public ScalableSize(@Nonnegative int n, @Nonnegative int n2) {
        this.m_nWidth = ValueEnforcer.isGE0(n, "Width");
        this.m_nHeight = ValueEnforcer.isGE0(n2, "Height");
    }

    @Override
    @Nonnegative
    public int getWidth() {
        return this.m_nWidth;
    }

    @Override
    @Nonnegative
    public int getHeight() {
        return this.m_nHeight;
    }

    @Nonnull
    @CheckReturnValue
    public ScalableSize getBestMatchingSize(@Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isGT0(n, "MaxWidth");
        ValueEnforcer.isGT0(n2, "MaxHeight");
        double d = MathHelper.getDividedDouble(this.m_nWidth, n);
        double d2 = MathHelper.getDividedDouble(this.m_nHeight, n2);
        if (d > d2) {
            if (this.m_nWidth > n) {
                return new ScalableSize(n, (int)((double)this.m_nHeight / d));
            }
        } else if (this.m_nHeight > n2) {
            return new ScalableSize((int)((double)this.m_nWidth / d2), n2);
        }
        return this;
    }

    @Nonnull
    @CheckReturnValue
    public ScalableSize getScaledToWidth(@Nonnegative int n) {
        ValueEnforcer.isGT0(n, "NewWidth");
        if (this.m_nWidth == n) {
            return this;
        }
        double d = MathHelper.getDividedDouble(n, this.m_nWidth);
        return new ScalableSize(n, (int)((double)this.m_nHeight * d));
    }

    @Nonnull
    @CheckReturnValue
    public ScalableSize getScaledToHeight(@Nonnegative int n) {
        ValueEnforcer.isGT0(n, "NewHeight");
        if (this.m_nHeight == n) {
            return this;
        }
        double d = MathHelper.getDividedDouble(n, this.m_nHeight);
        return new ScalableSize((int)((double)this.m_nWidth * d), n);
    }

    @Nonnull
    @CheckReturnValue
    public ScalableSize getAdded(@Nonnull IHasWidthAndHeight iHasWidthAndHeight) {
        ValueEnforcer.notNull(iHasWidthAndHeight, "ToAdd");
        return new ScalableSize(this.m_nWidth + iHasWidthAndHeight.getWidth(), this.m_nHeight + iHasWidthAndHeight.getHeight());
    }

    @Nonnull
    @CheckReturnValue
    public ScalableSize getSubtracted(@Nonnull IHasWidthAndHeight iHasWidthAndHeight) {
        ValueEnforcer.notNull(iHasWidthAndHeight, "ToSubtract");
        return new ScalableSize(this.m_nWidth - iHasWidthAndHeight.getWidth(), this.m_nHeight - iHasWidthAndHeight.getHeight());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ScalableSize scalableSize = (ScalableSize)object;
        return this.m_nWidth == scalableSize.m_nWidth && this.m_nHeight == scalableSize.m_nHeight;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_nWidth).append(this.m_nHeight).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("width", this.m_nWidth).append("height", this.m_nHeight).toString();
    }
}

