/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.hash;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.hash.HashCodeCalculator;
import com.helger.commons.hash.IHashCodeGenerator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.w3c.dom.Node;

@NotThreadSafe
public final class HashCodeGenerator
implements IHashCodeGenerator {
    public static final int INITIAL_HASHCODE = 17;
    private boolean m_bClosed = false;
    private int m_nHC = 17;

    public HashCodeGenerator(@Nonnull Object object) {
        this(object instanceof Class ? (Class<?>)object : object.getClass());
    }

    public HashCodeGenerator(@Nonnull Class<?> clazz) {
        ValueEnforcer.notNull(clazz, "Class");
        this.append(clazz.getName());
        Class<?> clazz2 = clazz.getComponentType();
        if (clazz2 != null) {
            this.append(clazz2.getName());
        }
    }

    private HashCodeGenerator(int n) {
        this.m_nHC = n;
    }

    public boolean isClosed() {
        return this.m_bClosed;
    }

    private void _checkClosed() {
        if (this.m_bClosed) {
            throw new IllegalStateException("Hash code cannot be changed anymore!");
        }
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(boolean bl) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, bl);
        return this;
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(byte by) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, by);
        return this;
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(char c) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, c);
        return this;
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(double d) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, d);
        return this;
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(float f) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, f);
        return this;
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(int n) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, n);
        return this;
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(long l) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, l);
        return this;
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(short s) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, s);
        return this;
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(@Nullable Object object) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, object);
        return this;
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(@Nullable Enum<?> enum_) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, enum_);
        return this;
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(@Nullable boolean[] blArray) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, blArray);
        return this;
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(@Nullable byte[] byArray) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, byArray);
        return this;
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(@Nullable char[] cArray) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, cArray);
        return this;
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(@Nullable double[] dArray) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, dArray);
        return this;
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(@Nullable float[] fArray) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, fArray);
        return this;
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(@Nullable int[] nArray) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, nArray);
        return this;
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(@Nullable long[] lArray) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, lArray);
        return this;
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(@Nullable short[] sArray) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, sArray);
        return this;
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(@Nullable Object[] objectArray) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, objectArray);
        return this;
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(@Nullable Enum<?>[] enumArray) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, enumArray);
        return this;
    }

    @Nonnull
    public HashCodeGenerator append(@Nullable StringBuffer stringBuffer) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, stringBuffer);
        return this;
    }

    @Nonnull
    public HashCodeGenerator append(@Nullable StringBuilder stringBuilder) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, stringBuilder);
        return this;
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(@Nullable Iterable<?> iterable) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, iterable);
        return this;
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(@Nullable Map<?, ?> map) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, map);
        return this;
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(@Nullable Node node) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, node);
        return this;
    }

    @Override
    public int getHashCode() {
        this.m_bClosed = true;
        if (this.m_nHC == 0) {
            this.m_nHC = -1;
        }
        return this.m_nHC;
    }

    @Nonnull
    public Integer getHashCodeObj() {
        return this.getHashCode();
    }

    @Deprecated
    public boolean equals(Object object) {
        return object == this;
    }

    @Deprecated
    public int hashCode() {
        return this.getHashCode();
    }

    @Nonnull
    public static HashCodeGenerator getDerived(int n) {
        if (n == 0) {
            throw new IllegalArgumentException("Passed hash code is invalid!");
        }
        return new HashCodeGenerator(n);
    }
}

