/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.file.filter;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.io.file.filter.AbstractFileFilter;
import com.helger.commons.string.ToStringGenerator;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class FilenameFilterEquals
extends AbstractFileFilter {
    private final String m_sFilename;

    public FilenameFilterEquals(@Nonnull @Nonempty String string) {
        this.m_sFilename = ValueEnforcer.notEmpty(string, "Filename");
    }

    @Nonnull
    @Nonempty
    public String getFilename() {
        return this.m_sFilename;
    }

    @Override
    public boolean matchesFilter(@Nullable File file) {
        return file != null && FilenameHelper.getSecureFilename(file.getName()).equals(this.m_sFilename);
    }

    public String toString() {
        return new ToStringGenerator(this).append("filename", this.m_sFilename).toString();
    }
}

