/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.file.filter;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.ArrayHelper;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.io.file.filter.AbstractFileFilter;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.ToStringGenerator;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class FilenameFilterMatchNoRegEx
extends AbstractFileFilter {
    private final String[] m_aRegExs;

    public FilenameFilterMatchNoRegEx(@Nonnull @Nonempty String string) {
        this(new String[]{string});
    }

    public FilenameFilterMatchNoRegEx(String ... stringArray) {
        this.m_aRegExs = ArrayHelper.getCopy(ValueEnforcer.notEmpty(stringArray, "RegularExpressions"));
    }

    @Nonnull
    @ReturnsMutableCopy
    public String[] getRegularExpressions() {
        return ArrayHelper.getCopy(this.m_aRegExs);
    }

    @Override
    public boolean matchesFilter(@Nullable File file) {
        if (file == null) {
            return false;
        }
        String string = FilenameHelper.getSecureFilename(file.getName());
        if (string == null) {
            return false;
        }
        for (String string2 : this.m_aRegExs) {
            if (!RegExHelper.stringMatchesPattern(string2, string)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return new ToStringGenerator(this).append("regExs", this.m_aRegExs).toString();
    }
}

