/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.resource;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.callback.INonThrowingRunnableWithParameter;
import com.helger.commons.equals.EqualsUtils;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.io.IReadableResource;
import com.helger.commons.io.streams.StreamUtils;
import com.helger.commons.mutable.IWrapper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.url.ISimpleURL;
import com.helger.commons.url.URLUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class URLResource
implements IReadableResource {
    public static final String PROTOCOL_FILE = "file";
    public static final int DEFAULT_CONNECT_TIMEOUT = -1;
    public static final int DEFAULT_READ_TIMEOUT = -1;
    private static final Logger s_aLogger = LoggerFactory.getLogger(URLResource.class);
    private final URL m_aURL;

    public URLResource(@Nonnull ISimpleURL iSimpleURL) throws MalformedURLException {
        this(iSimpleURL.getAsString());
    }

    public URLResource(@Nonnull String string) throws MalformedURLException {
        this(new URL(string));
    }

    public URLResource(@Nonnull URI uRI) throws MalformedURLException {
        this(uRI.toURL());
    }

    public URLResource(@Nonnull URL uRL) {
        this.m_aURL = ValueEnforcer.notNull(uRL, "URL");
    }

    public static boolean isExplicitURLResource(@Nullable String string) {
        return URLUtils.getAsURL(string) != null;
    }

    @Override
    @Nonnull
    public String getResourceID() {
        return this.getPath();
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.m_aURL.toExternalForm();
    }

    @Nullable
    public static InputStream getInputStream(@Nonnull URL uRL) {
        return URLUtils.getInputStream(uRL, -1, -1, null, null);
    }

    @Override
    @Nullable
    public InputStream getInputStream() {
        return this.getInputStream(-1, -1);
    }

    @Nullable
    public InputStream getInputStream(int n, int n2) {
        return this.getInputStream(n, n2, null, null);
    }

    @Nullable
    public InputStream getInputStream(@Nullable IWrapper<IOException> iWrapper) {
        return this.getInputStream(-1, -1, iWrapper);
    }

    @Nullable
    public InputStream getInputStream(int n, int n2, @Nullable IWrapper<IOException> iWrapper) {
        return this.getInputStream(n, n2, null, iWrapper);
    }

    @Nullable
    public InputStream getInputStream(int n, int n2, @Nullable INonThrowingRunnableWithParameter<URLConnection> iNonThrowingRunnableWithParameter, @Nullable IWrapper<IOException> iWrapper) {
        return URLUtils.getInputStream(this.m_aURL, n, n2, iNonThrowingRunnableWithParameter, iWrapper);
    }

    @Override
    @Nullable
    @Deprecated
    public Reader getReader(@Nonnull String string) {
        return StreamUtils.createReader(this.getInputStream(), string);
    }

    @Override
    @Nullable
    public Reader getReader(@Nonnull Charset charset) {
        return StreamUtils.createReader(this.getInputStream(), charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists() {
        if (PROTOCOL_FILE.equals(this.m_aURL.getProtocol())) {
            return this.getAsFile().exists();
        }
        InputStream inputStream = null;
        try {
            inputStream = this.getInputStream();
            boolean bl = inputStream != null;
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            StreamUtils.close(inputStream);
        }
    }

    @Override
    @Nonnull
    public URL getAsURL() {
        return this.m_aURL;
    }

    @Nullable
    public URI getAsURI() {
        return URLUtils.getAsURI(this.m_aURL);
    }

    @Nonnull
    public static File getAsFile(@Nonnull URL uRL) {
        File file;
        ValueEnforcer.notNull(uRL, "URL");
        if (!PROTOCOL_FILE.equals(uRL.getProtocol())) {
            throw new IllegalArgumentException("Not a file URL: " + uRL);
        }
        try {
            file = new File(uRL.toURI().getSchemeSpecificPart());
        }
        catch (URISyntaxException uRISyntaxException) {
            file = new File(uRL.getPath());
        }
        return file;
    }

    @Override
    @Nonnull
    public File getAsFile() {
        return URLResource.getAsFile(this.m_aURL);
    }

    @Nonnull
    public URLResource getReadableCloneForPath(@Nonnull URL uRL) {
        return new URLResource(uRL);
    }

    @Override
    @Nonnull
    public URLResource getReadableCloneForPath(@Nonnull String string) {
        try {
            return new URLResource(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Cannot convert to an URL: " + string, malformedURLException);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        URLResource uRLResource = (URLResource)object;
        return EqualsUtils.equals(this.m_aURL, uRLResource.m_aURL);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aURL).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("url", this.m_aURL).toString();
    }
}

