/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.resource.inmemory;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.ArrayHelper;
import com.helger.commons.io.resource.inmemory.AbstractMemoryReadableResource;
import com.helger.commons.io.streams.NonBlockingByteArrayInputStream;
import com.helger.commons.string.ToStringGenerator;
import java.io.InputStream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ReadableResourceByteArray
extends AbstractMemoryReadableResource {
    private final byte[] m_aBytes;

    public ReadableResourceByteArray(@Nonnull byte[] byArray) {
        this.m_aBytes = ArrayHelper.getCopy(ValueEnforcer.notNull(byArray, "Schematron"));
    }

    @Override
    @Nonnull
    public String getResourceID() {
        return "byte[]";
    }

    @Override
    @Nullable
    public InputStream getInputStream() {
        return new NonBlockingByteArrayInputStream(this.m_aBytes);
    }

    @Nonnull
    @ReturnsMutableCopy
    public byte[] getByteArray() {
        return ArrayHelper.getCopy(this.m_aBytes);
    }

    @Nonnegative
    public int size() {
        return this.m_aBytes.length;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("byte#", this.m_aBytes.length).toString();
    }
}

