/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.streams;

import com.helger.commons.io.streams.NonBlockingBitOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;

public class BitOutputStream
extends NonBlockingBitOutputStream {
    private final Lock m_aLock = new ReentrantLock();

    public BitOutputStream(@Nonnull OutputStream outputStream, @Nonnull ByteOrder byteOrder) {
        super(outputStream, byteOrder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeBit(int n) throws IOException {
        this.m_aLock.lock();
        try {
            super.writeBit(n);
        }
        finally {
            this.m_aLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        this.m_aLock.lock();
        try {
            super.flush();
        }
        finally {
            this.m_aLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.m_aLock.lock();
        try {
            super.close();
        }
        finally {
            this.m_aLock.unlock();
        }
    }
}

