/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.jmx;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.jmx.ObjectNameUtils;
import com.helger.commons.state.ESuccess;
import java.lang.management.ManagementFactory;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.management.JMException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class JMXUtils {
    private static final Logger s_aLogger = LoggerFactory.getLogger(JMXUtils.class);
    private static final JMXUtils s_aInstance = new JMXUtils();

    private JMXUtils() {
    }

    @Nonnull
    public static ESuccess exposeMBean(@Nonnull Object object, @Nonnull ObjectName objectName) {
        ValueEnforcer.notNull(object, "Object");
        ValueEnforcer.notNull(objectName, "ObjectName");
        try {
            ManagementFactory.getPlatformMBeanServer().registerMBean(object, objectName);
            return ESuccess.SUCCESS;
        }
        catch (JMException jMException) {
            s_aLogger.error("Error registering MBean with name " + objectName, (Throwable)jMException);
            return ESuccess.FAILURE;
        }
    }

    @Nonnull
    public static ESuccess exposeMBeanWithAutoName(@Nonnull Object object) {
        return JMXUtils.exposeMBean(object, ObjectNameUtils.createWithDefaultProperties(object));
    }

    @Nonnull
    public static ESuccess exposeMBeanWithAutoName(@Nonnull Object object, @Nonnull String string) {
        return JMXUtils.exposeMBean(object, ObjectNameUtils.createWithDefaultProperties(object, string));
    }
}

