/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.log;

import com.helger.commons.IHasSize;
import com.helger.commons.annotations.OverrideOnDemand;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.ContainerHelper;
import com.helger.commons.error.EErrorLevel;
import com.helger.commons.error.IHasErrorLevels;
import com.helger.commons.log.LogMessage;
import com.helger.commons.state.EChange;
import com.helger.commons.state.IClearable;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class InMemoryLogger
implements Iterable<LogMessage>,
IHasSize,
IClearable,
IHasErrorLevels,
Serializable {
    private final List<LogMessage> m_aMessages = new ArrayList<LogMessage>();

    @Nullable
    @OverrideOnDemand
    protected LogMessage createLogMessage(@Nonnull EErrorLevel eErrorLevel, @Nonnull Serializable serializable, @Nullable Throwable throwable) {
        return new LogMessage(eErrorLevel, serializable, throwable);
    }

    @OverrideOnDemand
    protected void onAddLogMessage(@Nonnull LogMessage logMessage) {
    }

    public void log(@Nonnull EErrorLevel eErrorLevel, @Nonnull Serializable serializable) {
        this.log(eErrorLevel, serializable, null);
    }

    public void log(@Nonnull EErrorLevel eErrorLevel, @Nonnull Serializable serializable, @Nullable Throwable throwable) {
        LogMessage logMessage = this.createLogMessage(eErrorLevel, serializable, throwable);
        if (logMessage != null) {
            this.m_aMessages.add(logMessage);
            this.onAddLogMessage(logMessage);
        }
    }

    public void error(@Nonnull Serializable serializable) {
        this.error(serializable, null);
    }

    public void error(@Nonnull Serializable serializable, @Nullable Throwable throwable) {
        this.log(EErrorLevel.ERROR, serializable, throwable);
    }

    public void warn(@Nonnull Serializable serializable) {
        this.warn(serializable, null);
    }

    public void warn(@Nonnull Serializable serializable, @Nullable Throwable throwable) {
        this.log(EErrorLevel.WARN, serializable, throwable);
    }

    public void info(@Nonnull Serializable serializable) {
        this.log(EErrorLevel.INFO, serializable, null);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<LogMessage> getAllMessages() {
        return ContainerHelper.newList(this.m_aMessages);
    }

    @Override
    @Nonnull
    public Iterator<LogMessage> iterator() {
        return this.m_aMessages.iterator();
    }

    @Override
    @Nonnegative
    public int size() {
        return this.m_aMessages.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m_aMessages.isEmpty();
    }

    @Override
    public boolean containsOnlySuccess() {
        if (this.m_aMessages.isEmpty()) {
            return false;
        }
        for (LogMessage logMessage : this.m_aMessages) {
            if (!logMessage.isFailure()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAtLeastOneSuccess() {
        for (LogMessage logMessage : this.m_aMessages) {
            if (!logMessage.isSuccess()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsNoSuccess() {
        for (LogMessage logMessage : this.m_aMessages) {
            if (!logMessage.isSuccess()) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nonnegative
    public int getSuccessCount() {
        int n = 0;
        for (LogMessage logMessage : this.m_aMessages) {
            if (!logMessage.isSuccess()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public boolean containsOnlyFailure() {
        if (this.m_aMessages.isEmpty()) {
            return false;
        }
        for (LogMessage logMessage : this.m_aMessages) {
            if (!logMessage.isSuccess()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAtLeastOneFailure() {
        for (LogMessage logMessage : this.m_aMessages) {
            if (!logMessage.isFailure()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsNoFailure() {
        for (LogMessage logMessage : this.m_aMessages) {
            if (!logMessage.isFailure()) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nonnegative
    public int getFailureCount() {
        int n = 0;
        for (LogMessage logMessage : this.m_aMessages) {
            if (!logMessage.isFailure()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public boolean containsOnlyError() {
        if (this.m_aMessages.isEmpty()) {
            return false;
        }
        for (LogMessage logMessage : this.m_aMessages) {
            if (!logMessage.isNoError()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAtLeastOneError() {
        for (LogMessage logMessage : this.m_aMessages) {
            if (!logMessage.isError()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsNoError() {
        for (LogMessage logMessage : this.m_aMessages) {
            if (!logMessage.isError()) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nonnegative
    public int getErrorCount() {
        int n = 0;
        for (LogMessage logMessage : this.m_aMessages) {
            if (!logMessage.isError()) continue;
            ++n;
        }
        return n;
    }

    @Override
    @Nonnull
    public EErrorLevel getMostSevereErrorLevel() {
        LogMessage logMessage;
        EErrorLevel eErrorLevel;
        EErrorLevel eErrorLevel2 = EErrorLevel.SUCCESS;
        Iterator<LogMessage> iterator = this.m_aMessages.iterator();
        while (iterator.hasNext() && (!(eErrorLevel = (logMessage = iterator.next()).getErrorLevel()).isMoreSevereThan(eErrorLevel2) || (eErrorLevel2 = eErrorLevel) != EErrorLevel.HIGHEST)) {
        }
        return eErrorLevel2;
    }

    @Override
    @Nonnull
    public EChange clear() {
        if (this.m_aMessages.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aMessages.clear();
        return EChange.CHANGED;
    }

    public String toString() {
        return new ToStringGenerator(this).append("messages", this.m_aMessages).toString();
    }
}

