/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.microdom.convert;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.microdom.IMicroElement;
import com.helger.commons.microdom.convert.IMicroTypeConverter;
import com.helger.commons.microdom.convert.MicroTypeConverterRegistry;
import com.helger.commons.typeconvert.TypeConverterException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class MicroTypeConverter {
    private static final MicroTypeConverter s_aInstance = new MicroTypeConverter();

    private MicroTypeConverter() {
    }

    @Nullable
    public static IMicroElement convertToMicroElement(@Nullable Object object, @Nonnull @Nonempty String string) {
        return MicroTypeConverter.convertToMicroElement(object, null, string);
    }

    @Nullable
    public static IMicroElement convertToMicroElement(@Nullable Object object, @Nullable String string, @Nonnull @Nonempty String string2) throws TypeConverterException {
        ValueEnforcer.notEmpty(string2, "TagName");
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        IMicroTypeConverter iMicroTypeConverter = MicroTypeConverterRegistry.getInstance().getConverterToMicroElement(clazz);
        if (iMicroTypeConverter == null) {
            throw new TypeConverterException(clazz, IMicroElement.class, TypeConverterException.EReason.NO_CONVERTER_FOUND);
        }
        IMicroElement iMicroElement = iMicroTypeConverter.convertToMicroElement(object, string, string2);
        if (iMicroElement == null) {
            throw new TypeConverterException(clazz, IMicroElement.class, TypeConverterException.EReason.CONVERSION_FAILED);
        }
        return iMicroElement;
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE convertToNative(@Nullable IMicroElement iMicroElement, @Nonnull Class<DSTTYPE> clazz) throws TypeConverterException {
        ValueEnforcer.notNull(clazz, "DestClass");
        if (iMicroElement == null) {
            return null;
        }
        IMicroTypeConverter iMicroTypeConverter = MicroTypeConverterRegistry.getInstance().getConverterToNative(clazz);
        if (iMicroTypeConverter == null) {
            throw new TypeConverterException(IMicroElement.class, clazz, TypeConverterException.EReason.NO_CONVERTER_FOUND);
        }
        DSTTYPE DSTTYPE = clazz.cast(iMicroTypeConverter.convertToNative(iMicroElement));
        if (DSTTYPE == null) {
            throw new TypeConverterException(IMicroElement.class, clazz, TypeConverterException.EReason.CONVERSION_FAILED);
        }
        return DSTTYPE;
    }
}

