/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.microdom.impl;

import com.helger.commons.GlobalDebug;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.ContainerHelper;
import com.helger.commons.equals.EqualsUtils;
import com.helger.commons.microdom.EMicroNodeType;
import com.helger.commons.microdom.IHasAttributeValue;
import com.helger.commons.microdom.IHasElementName;
import com.helger.commons.microdom.IMicroElement;
import com.helger.commons.microdom.IMicroNode;
import com.helger.commons.microdom.IMicroQName;
import com.helger.commons.microdom.impl.AbstractMicroNodeWithChildren;
import com.helger.commons.microdom.impl.MicroAttribute;
import com.helger.commons.microdom.impl.MicroQName;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.typeconvert.TypeConverter;
import com.helger.commons.xml.CXMLRegEx;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MicroElement
extends AbstractMicroNodeWithChildren
implements IMicroElement {
    private static final Logger s_aLogger = LoggerFactory.getLogger(MicroElement.class);
    private String m_sNamespaceURI;
    private final String m_sTagName;
    private Map<IMicroQName, MicroAttribute> m_aAttrs;

    public MicroElement(@Nonnull IHasElementName iHasElementName) {
        this(null, iHasElementName.getElementName());
    }

    public MicroElement(@Nullable String string, @Nonnull IHasElementName iHasElementName) {
        this(string, iHasElementName.getElementName());
    }

    public MicroElement(@Nonnull @Nonempty String string) {
        this(null, string);
    }

    public MicroElement(@Nullable String string, @Nonnull @Nonempty String string2) {
        int n;
        ValueEnforcer.notEmpty(string2, "TagName");
        this.m_sNamespaceURI = string;
        int n2 = n = string != null ? string2.indexOf(58) : -1;
        if (n == -1) {
            this.m_sTagName = string2;
        } else {
            s_aLogger.warn("Removing micro element namespace prefix '" + string2.substring(0, n) + "' from tag name '" + string2 + "'");
            this.m_sTagName = string2.substring(n + 1);
        }
        if (GlobalDebug.isDebugMode() && !CXMLRegEx.PATTERN_NAME_QUICK.matcher(this.m_sTagName).matches() && !CXMLRegEx.PATTERN_NAME.matcher(this.m_sTagName).matches()) {
            throw new IllegalArgumentException("The micro element tag name '" + this.m_sTagName + "' is not a valid element name!");
        }
    }

    @Override
    @Nonnull
    public EMicroNodeType getType() {
        return EMicroNodeType.ELEMENT;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getNodeName() {
        return this.m_sTagName;
    }

    @Override
    public boolean hasAttributes() {
        return this.m_aAttrs != null && !this.m_aAttrs.isEmpty();
    }

    @Override
    public boolean hasNoAttributes() {
        return this.m_aAttrs == null || this.m_aAttrs.isEmpty();
    }

    @Override
    @Nonnegative
    public int getAttributeCount() {
        return this.m_aAttrs == null ? 0 : this.m_aAttrs.size();
    }

    @Override
    @Nullable
    @ReturnsMutableCopy
    public Map<String, String> getAllAttributes() {
        if (this.hasNoAttributes()) {
            return null;
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (MicroAttribute microAttribute : this.m_aAttrs.values()) {
            linkedHashMap.put(microAttribute.getAttributeName(), microAttribute.getAttributeValue());
        }
        return linkedHashMap;
    }

    @Override
    @Nullable
    @ReturnsMutableCopy
    public Map<IMicroQName, String> getAllQAttributes() {
        if (this.hasNoAttributes()) {
            return null;
        }
        LinkedHashMap<IMicroQName, String> linkedHashMap = new LinkedHashMap<IMicroQName, String>();
        for (MicroAttribute microAttribute : this.m_aAttrs.values()) {
            linkedHashMap.put(microAttribute.getAttributeQName(), microAttribute.getAttributeValue());
        }
        return linkedHashMap;
    }

    @Override
    @Nullable
    @ReturnsMutableCopy
    public Set<String> getAllAttributeNames() {
        if (this.hasNoAttributes()) {
            return null;
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (IMicroQName iMicroQName : this.m_aAttrs.keySet()) {
            linkedHashSet.add(iMicroQName.getName());
        }
        return linkedHashSet;
    }

    @Override
    @Nullable
    @ReturnsMutableCopy
    public Set<IMicroQName> getAllAttributeQNames() {
        if (this.hasNoAttributes()) {
            return null;
        }
        return ContainerHelper.newOrderedSet(this.m_aAttrs.keySet());
    }

    @Nullable
    @ReturnsMutableCopy
    public List<String> getAllAttributeValues() {
        if (this.hasNoAttributes()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (MicroAttribute microAttribute : this.m_aAttrs.values()) {
            arrayList.add(microAttribute.getAttributeValue());
        }
        return arrayList;
    }

    @Override
    @Nullable
    public MicroAttribute getAttributeObj(@Nullable String string) {
        return this.getAttributeObj(null, string);
    }

    @Override
    @Nullable
    public MicroAttribute getAttributeObj(@Nullable String string, @Nullable String string2) {
        if (StringHelper.hasNoText(string2)) {
            return null;
        }
        return this.getAttributeObj(new MicroQName(string, string2));
    }

    @Override
    @Nullable
    public MicroAttribute getAttributeObj(@Nullable IMicroQName iMicroQName) {
        return iMicroQName == null || this.m_aAttrs == null ? null : this.m_aAttrs.get(iMicroQName);
    }

    @Override
    @Nullable
    public String getAttributeValue(@Nullable String string) {
        MicroAttribute microAttribute = this.getAttributeObj(string);
        return microAttribute == null ? null : microAttribute.getAttributeValue();
    }

    @Override
    @Nullable
    public String getAttributeValue(@Nullable String string, @Nullable String string2) {
        MicroAttribute microAttribute = this.getAttributeObj(string, string2);
        return microAttribute == null ? null : microAttribute.getAttributeValue();
    }

    @Override
    @Nullable
    public String getAttributeValue(@Nullable IMicroQName iMicroQName) {
        MicroAttribute microAttribute = this.getAttributeObj(iMicroQName);
        return microAttribute == null ? null : microAttribute.getAttributeValue();
    }

    @Nullable
    private static <DSTTYPE> DSTTYPE _convert(@Nullable String string, @Nonnull Class<DSTTYPE> clazz) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        DSTTYPE DSTTYPE = TypeConverter.convertIfNecessary(string, clazz);
        return DSTTYPE;
    }

    @Override
    @Nullable
    public <DSTTYPE> DSTTYPE getAttributeWithConversion(@Nullable String string, @Nonnull Class<DSTTYPE> clazz) {
        return MicroElement._convert(this.getAttributeValue(string), clazz);
    }

    @Override
    @Nullable
    public <DSTTYPE> DSTTYPE getAttributeWithConversion(@Nullable String string, @Nullable String string2, @Nonnull Class<DSTTYPE> clazz) {
        return MicroElement._convert(this.getAttributeValue(string, string2), clazz);
    }

    @Override
    @Nullable
    public <DSTTYPE> DSTTYPE getAttributeWithConversion(@Nullable IMicroQName iMicroQName, @Nonnull Class<DSTTYPE> clazz) {
        return MicroElement._convert(this.getAttributeValue(iMicroQName), clazz);
    }

    @Override
    public boolean hasAttribute(@Nullable String string) {
        return this.hasAttribute(null, string);
    }

    @Override
    public boolean hasAttribute(@Nullable String string, @Nullable String string2) {
        if (StringHelper.hasNoText(string2)) {
            return false;
        }
        return this.hasAttribute(new MicroQName(string, string2));
    }

    @Override
    public boolean hasAttribute(@Nullable IMicroQName iMicroQName) {
        return this.m_aAttrs != null && iMicroQName != null && this.m_aAttrs.containsKey(iMicroQName);
    }

    @Override
    @Nonnull
    public EChange removeAttribute(@Nullable String string) {
        return this.removeAttribute(null, string);
    }

    @Override
    @Nonnull
    public EChange removeAttribute(@Nullable String string, @Nullable String string2) {
        if (StringHelper.hasNoText(string2)) {
            return EChange.UNCHANGED;
        }
        return this.removeAttribute(new MicroQName(string, string2));
    }

    @Override
    @Nonnull
    public EChange removeAttribute(@Nullable IMicroQName iMicroQName) {
        return EChange.valueOf(this.m_aAttrs != null && iMicroQName != null && this.m_aAttrs.remove(iMicroQName) != null);
    }

    @Override
    @Nonnull
    public MicroElement setAttribute(@Nonnull @Nonempty String string, @Nullable String string2) {
        return this.setAttribute((IMicroQName)new MicroQName(string), string2);
    }

    @Override
    @Nonnull
    public MicroElement setAttribute(@Nullable String string, @Nonnull @Nonempty String string2, @Nullable String string3) {
        return this.setAttribute((IMicroQName)new MicroQName(string, string2), string3);
    }

    @Override
    @Nonnull
    public MicroElement setAttribute(@Nonnull IMicroQName iMicroQName, @Nullable String string) {
        ValueEnforcer.notNull(iMicroQName, "AttrName");
        if (string != null) {
            if (this.m_aAttrs == null) {
                this.m_aAttrs = new LinkedHashMap<IMicroQName, MicroAttribute>();
            }
            this.m_aAttrs.put(iMicroQName, new MicroAttribute(iMicroQName, string));
        } else {
            this.removeAttribute(iMicroQName);
        }
        return this;
    }

    @Override
    @Nonnull
    public MicroElement setAttribute(@Nonnull String string, @Nonnull IHasAttributeValue iHasAttributeValue) {
        return this.setAttribute((IMicroQName)new MicroQName(string), iHasAttributeValue);
    }

    @Override
    @Nonnull
    public MicroElement setAttribute(@Nullable String string, @Nonnull String string2, @Nonnull IHasAttributeValue iHasAttributeValue) {
        return this.setAttribute((IMicroQName)new MicroQName(string, string2), iHasAttributeValue);
    }

    @Override
    @Nonnull
    public MicroElement setAttribute(@Nonnull IMicroQName iMicroQName, @Nonnull IHasAttributeValue iHasAttributeValue) {
        ValueEnforcer.notNull(iHasAttributeValue, "AttrValueProvider");
        return this.setAttribute(iMicroQName, iHasAttributeValue.getAttrValue());
    }

    @Override
    @Nonnull
    public IMicroElement setAttribute(@Nonnull String string, int n) {
        return this.setAttribute(string, Integer.toString(n));
    }

    @Override
    @Nonnull
    public IMicroElement setAttribute(@Nullable String string, @Nonnull String string2, int n) {
        return this.setAttribute(string, string2, Integer.toString(n));
    }

    @Override
    @Nonnull
    public IMicroElement setAttribute(@Nonnull IMicroQName iMicroQName, int n) {
        return this.setAttribute(iMicroQName, Integer.toString(n));
    }

    @Override
    @Nonnull
    public IMicroElement setAttribute(@Nonnull String string, long l) {
        return this.setAttribute(string, Long.toString(l));
    }

    @Override
    @Nonnull
    public IMicroElement setAttribute(@Nullable String string, @Nonnull String string2, long l) {
        return this.setAttribute(string, string2, Long.toString(l));
    }

    @Override
    @Nonnull
    public IMicroElement setAttribute(@Nonnull IMicroQName iMicroQName, long l) {
        return this.setAttribute(iMicroQName, Long.toString(l));
    }

    @Override
    @Nonnull
    public IMicroElement setAttributeWithConversion(@Nonnull String string, @Nullable Object object) {
        return this.setAttributeWithConversion(new MicroQName(string), object);
    }

    @Override
    @Nonnull
    public IMicroElement setAttributeWithConversion(@Nullable String string, @Nonnull String string2, @Nullable Object object) {
        return this.setAttributeWithConversion(new MicroQName(string, string2), object);
    }

    @Override
    @Nonnull
    public IMicroElement setAttributeWithConversion(@Nonnull IMicroQName iMicroQName, @Nullable Object object) {
        String string = TypeConverter.convertIfNecessary(object, String.class);
        return this.setAttribute(iMicroQName, string);
    }

    @Override
    @Nonnull
    public EChange removeAllAttributes() {
        if (ContainerHelper.isEmpty(this.m_aAttrs)) {
            return EChange.UNCHANGED;
        }
        this.m_aAttrs.clear();
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getNamespaceURI() {
        return this.m_sNamespaceURI;
    }

    @Override
    @Nonnull
    public EChange setNamespaceURI(@Nullable String string) {
        if (EqualsUtils.equals(this.m_sNamespaceURI, string)) {
            return EChange.UNCHANGED;
        }
        this.m_sNamespaceURI = string;
        return EChange.CHANGED;
    }

    @Override
    public boolean hasNamespaceURI() {
        return StringHelper.hasText(this.m_sNamespaceURI);
    }

    @Override
    public boolean hasNoNamespaceURI() {
        return StringHelper.hasNoText(this.m_sNamespaceURI);
    }

    @Override
    public boolean hasNamespaceURI(@Nullable String string) {
        return EqualsUtils.equals(this.m_sNamespaceURI, string);
    }

    @Override
    @Nullable
    public String getLocalName() {
        return this.m_sNamespaceURI == null ? null : this.m_sTagName;
    }

    @Override
    @Nonnull
    public String getTagName() {
        return this.m_sTagName;
    }

    @Override
    @Nonnegative
    public int getChildElementCount() {
        int n = 0;
        if (this.hasChildren()) {
            for (IMicroNode iMicroNode : this.directGetChildren()) {
                if (iMicroNode.isElement()) {
                    ++n;
                    continue;
                }
                if (!iMicroNode.isContainer() || !iMicroNode.hasChildren()) continue;
                for (IMicroNode iMicroNode2 : iMicroNode.getAllChildren()) {
                    if (!iMicroNode2.isElement()) continue;
                    ++n;
                }
            }
        }
        return n;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<IMicroElement> getAllChildElements() {
        ArrayList<IMicroElement> arrayList = new ArrayList<IMicroElement>();
        if (this.hasChildren()) {
            for (IMicroNode iMicroNode : this.directGetChildren()) {
                if (iMicroNode.isElement()) {
                    arrayList.add((IMicroElement)iMicroNode);
                    continue;
                }
                if (!iMicroNode.isContainer() || !iMicroNode.hasChildren()) continue;
                for (IMicroNode iMicroNode2 : iMicroNode.getAllChildren()) {
                    if (!iMicroNode2.isElement()) continue;
                    arrayList.add((IMicroElement)iMicroNode2);
                }
            }
        }
        return arrayList;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<IMicroElement> getAllChildElements(@Nullable String string) {
        ArrayList<IMicroElement> arrayList = new ArrayList<IMicroElement>();
        if (this.hasChildren()) {
            for (IMicroNode iMicroNode : this.directGetChildren()) {
                if (iMicroNode.isElement()) {
                    IMicroElement iMicroElement = (IMicroElement)iMicroNode;
                    if (!iMicroElement.getTagName().equals(string)) continue;
                    arrayList.add(iMicroElement);
                    continue;
                }
                if (!iMicroNode.isContainer() || !iMicroNode.hasChildren()) continue;
                for (IMicroNode iMicroNode2 : iMicroNode.getAllChildren()) {
                    IMicroElement iMicroElement;
                    if (!iMicroNode2.isElement() || !(iMicroElement = (IMicroElement)iMicroNode2).getTagName().equals(string)) continue;
                    arrayList.add(iMicroElement);
                }
            }
        }
        return arrayList;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<IMicroElement> getAllChildElements(@Nullable String string, @Nullable String string2) {
        if (StringHelper.hasNoText(string)) {
            return this.getAllChildElements(string2);
        }
        ArrayList<IMicroElement> arrayList = new ArrayList<IMicroElement>();
        if (this.hasChildren()) {
            for (IMicroNode iMicroNode : this.directGetChildren()) {
                if (iMicroNode.isElement()) {
                    IMicroElement iMicroElement = (IMicroElement)iMicroNode;
                    if (!iMicroElement.hasNamespaceURI(string) || !iMicroElement.getLocalName().equals(string2)) continue;
                    arrayList.add(iMicroElement);
                    continue;
                }
                if (!iMicroNode.isContainer() || !iMicroNode.hasChildren()) continue;
                for (IMicroNode iMicroNode2 : iMicroNode.getAllChildren()) {
                    IMicroElement iMicroElement;
                    if (!iMicroNode2.isElement() || !(iMicroElement = (IMicroElement)iMicroNode2).hasNamespaceURI(string) || !iMicroElement.getLocalName().equals(string2)) continue;
                    arrayList.add(iMicroElement);
                }
            }
        }
        return arrayList;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<IMicroElement> getAllChildElements(@Nonnull IHasElementName iHasElementName) {
        ValueEnforcer.notNull(iHasElementName, "ElementNameProvider");
        return this.getAllChildElements(iHasElementName.getElementName());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<IMicroElement> getAllChildElements(@Nullable String string, @Nonnull IHasElementName iHasElementName) {
        ValueEnforcer.notNull(iHasElementName, "ElementNameProvider");
        return this.getAllChildElements(string, iHasElementName.getElementName());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<IMicroElement> getAllChildElementsRecursive() {
        ArrayList<IMicroElement> arrayList = new ArrayList<IMicroElement>();
        if (this.hasChildren()) {
            for (IMicroNode iMicroNode : this.directGetChildren()) {
                if (iMicroNode.isElement()) {
                    IMicroElement iMicroElement = (IMicroElement)iMicroNode;
                    arrayList.add(iMicroElement);
                    arrayList.addAll(iMicroElement.getAllChildElementsRecursive());
                    continue;
                }
                if (!iMicroNode.isContainer() || !iMicroNode.hasChildren()) continue;
                for (IMicroNode iMicroNode2 : iMicroNode.getAllChildren()) {
                    if (!iMicroNode2.isElement()) continue;
                    MicroElement microElement = (MicroElement)iMicroNode2;
                    arrayList.add(microElement);
                    arrayList.addAll(microElement.getAllChildElementsRecursive());
                }
            }
        }
        return arrayList;
    }

    @Override
    public boolean hasChildElements() {
        if (this.hasChildren()) {
            for (IMicroNode iMicroNode : this.directGetChildren()) {
                if (iMicroNode.isElement()) {
                    return true;
                }
                if (!iMicroNode.isContainer() || !iMicroNode.hasChildren()) continue;
                for (IMicroNode iMicroNode2 : iMicroNode.getAllChildren()) {
                    if (!iMicroNode2.isElement()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean hasChildElements(@Nullable String string) {
        if (this.hasChildren()) {
            for (IMicroNode iMicroNode : this.directGetChildren()) {
                if (iMicroNode.isElement()) {
                    if (!((IMicroElement)iMicroNode).getTagName().equals(string)) continue;
                    return true;
                }
                if (!iMicroNode.isContainer() || !iMicroNode.hasChildren()) continue;
                for (IMicroNode iMicroNode2 : iMicroNode.getAllChildren()) {
                    if (!iMicroNode2.isElement() || !((IMicroElement)iMicroNode2).getTagName().equals(string)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean hasChildElements(@Nullable String string, @Nullable String string2) {
        if (StringHelper.hasNoText(string)) {
            return this.hasChildElements(string2);
        }
        if (this.hasChildren()) {
            for (IMicroNode iMicroNode : this.directGetChildren()) {
                if (iMicroNode.isElement()) {
                    IMicroElement iMicroElement = (IMicroElement)iMicroNode;
                    if (!iMicroElement.hasNamespaceURI(string) || !iMicroElement.getLocalName().equals(string2)) continue;
                    return true;
                }
                if (!iMicroNode.isContainer() || !iMicroNode.hasChildren()) continue;
                for (IMicroNode iMicroNode2 : iMicroNode.getAllChildren()) {
                    IMicroElement iMicroElement;
                    if (!iMicroNode2.isElement() || !(iMicroElement = (IMicroElement)iMicroNode2).hasNamespaceURI(string) || !iMicroElement.getLocalName().equals(string2)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean hasChildElements(@Nonnull IHasElementName iHasElementName) {
        ValueEnforcer.notNull(iHasElementName, "ElementNameProvider");
        return this.hasChildElements(iHasElementName.getElementName());
    }

    @Override
    public boolean hasChildElements(@Nullable String string, @Nonnull IHasElementName iHasElementName) {
        ValueEnforcer.notNull(iHasElementName, "ElementNameProvider");
        return this.hasChildElements(string, iHasElementName.getElementName());
    }

    @Override
    @Nullable
    public IMicroElement getFirstChildElement() {
        if (this.hasChildren()) {
            for (IMicroNode iMicroNode : this.directGetChildren()) {
                if (iMicroNode.isElement()) {
                    return (IMicroElement)iMicroNode;
                }
                if (!iMicroNode.isContainer() || !iMicroNode.hasChildren()) continue;
                for (IMicroNode iMicroNode2 : iMicroNode.getAllChildren()) {
                    if (!iMicroNode2.isElement()) continue;
                    return (IMicroElement)iMicroNode2;
                }
            }
        }
        return null;
    }

    @Override
    @Nullable
    public IMicroElement getFirstChildElement(@Nullable String string) {
        if (this.hasChildren()) {
            for (IMicroNode iMicroNode : this.directGetChildren()) {
                if (iMicroNode.isElement()) {
                    IMicroElement iMicroElement = (IMicroElement)iMicroNode;
                    if (!iMicroElement.getTagName().equals(string)) continue;
                    return iMicroElement;
                }
                if (!iMicroNode.isContainer() || !iMicroNode.hasChildren()) continue;
                for (IMicroNode iMicroNode2 : iMicroNode.getAllChildren()) {
                    IMicroElement iMicroElement;
                    if (!iMicroNode2.isElement() || !(iMicroElement = (IMicroElement)iMicroNode2).getTagName().equals(string)) continue;
                    return iMicroElement;
                }
            }
        }
        return null;
    }

    @Override
    @Nullable
    public IMicroElement getFirstChildElement(@Nullable String string, @Nullable String string2) {
        if (StringHelper.hasNoText(string)) {
            return this.getFirstChildElement(string2);
        }
        if (this.hasChildren()) {
            for (IMicroNode iMicroNode : this.directGetChildren()) {
                if (iMicroNode.isElement()) {
                    IMicroElement iMicroElement = (IMicroElement)iMicroNode;
                    if (!iMicroElement.hasNamespaceURI(string) || !iMicroElement.getLocalName().equals(string2)) continue;
                    return iMicroElement;
                }
                if (!iMicroNode.isContainer() || !iMicroNode.hasChildren()) continue;
                for (IMicroNode iMicroNode2 : iMicroNode.getAllChildren()) {
                    IMicroElement iMicroElement;
                    if (!iMicroNode2.isElement() || !(iMicroElement = (IMicroElement)iMicroNode2).hasNamespaceURI(string) || !iMicroElement.getLocalName().equals(string2)) continue;
                    return iMicroElement;
                }
            }
        }
        return null;
    }

    @Override
    @Nullable
    public IMicroElement getFirstChildElement(@Nonnull IHasElementName iHasElementName) {
        ValueEnforcer.notNull(iHasElementName, "ElementNameProvider");
        return this.getFirstChildElement(iHasElementName.getElementName());
    }

    @Override
    @Nullable
    public IMicroElement getFirstChildElement(@Nullable String string, @Nonnull IHasElementName iHasElementName) {
        ValueEnforcer.notNull(iHasElementName, "ElementNameProvider");
        return this.getFirstChildElement(string, iHasElementName.getElementName());
    }

    @Override
    @Nonnull
    public IMicroElement getClone() {
        MicroElement microElement = new MicroElement(this.m_sNamespaceURI, this.m_sTagName);
        if (this.m_aAttrs != null) {
            microElement.m_aAttrs = ContainerHelper.newOrderedMap(this.m_aAttrs);
        }
        if (this.hasChildren()) {
            for (IMicroNode iMicroNode : this.directGetChildren()) {
                microElement.appendChild((IMicroNode)iMicroNode.getClone());
            }
        }
        return microElement;
    }

    @Override
    public boolean isEqualContent(@Nullable IMicroNode iMicroNode) {
        if (iMicroNode == this) {
            return true;
        }
        if (!super.isEqualContent(iMicroNode)) {
            return false;
        }
        MicroElement microElement = (MicroElement)iMicroNode;
        return EqualsUtils.equals(this.m_sNamespaceURI, microElement.m_sNamespaceURI) && this.m_sTagName.equals(microElement.m_sTagName) && EqualsUtils.equals(this.m_aAttrs, microElement.m_aAttrs);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).appendIfNotNull("namespace", this.m_sNamespaceURI).append("tagname", this.m_sTagName).appendIfNotNull("attrs", this.m_aAttrs).toString();
    }
}

