/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.microdom.utils;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.hierarchy.IHierarchyWalkerCallback;
import com.helger.commons.microdom.IMicroNode;
import com.helger.commons.parent.IChildrenProvider;
import com.helger.commons.parent.impl.ChildrenProviderHasChildren;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class MicroWalker {
    private static final MicroWalker s_aInstance = new MicroWalker();

    private MicroWalker() {
    }

    private static <T extends IMicroNode> void _walkNode(@Nonnull T t, @Nonnull IChildrenProvider<T> iChildrenProvider, @Nonnull IHierarchyWalkerCallback<? super T> iHierarchyWalkerCallback) {
        iHierarchyWalkerCallback.onItemBeforeChildren(t);
        if (iChildrenProvider.hasChildren(t)) {
            for (IMicroNode iMicroNode : iChildrenProvider.getAllChildren(t)) {
                iHierarchyWalkerCallback.onLevelDown();
                MicroWalker._walkNode(iMicroNode, iChildrenProvider, iHierarchyWalkerCallback);
                iHierarchyWalkerCallback.onLevelUp();
            }
        }
        iHierarchyWalkerCallback.onItemAfterChildren(t);
    }

    public static void walkNode(@Nonnull IMicroNode iMicroNode, @Nonnull IHierarchyWalkerCallback<? super IMicroNode> iHierarchyWalkerCallback) {
        MicroWalker.walkNode(iMicroNode, new ChildrenProviderHasChildren(), iHierarchyWalkerCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends IMicroNode> void walkNode(@Nonnull T t, @Nonnull IChildrenProvider<T> iChildrenProvider, @Nonnull IHierarchyWalkerCallback<? super T> iHierarchyWalkerCallback) {
        ValueEnforcer.notNull(t, "Node");
        ValueEnforcer.notNull(iHierarchyWalkerCallback, "Callback");
        iHierarchyWalkerCallback.begin();
        try {
            if (iChildrenProvider.hasChildren(t)) {
                for (IMicroNode iMicroNode : iChildrenProvider.getAllChildren(t)) {
                    MicroWalker._walkNode(iMicroNode, iChildrenProvider, iHierarchyWalkerCallback);
                }
            }
        }
        finally {
            iHierarchyWalkerCallback.end();
        }
    }
}

