/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.mime;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.MustBeLocked;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.charset.CharsetManager;
import com.helger.commons.charset.EUnicodeBOM;
import com.helger.commons.collections.ArrayHelper;
import com.helger.commons.collections.ContainerHelper;
import com.helger.commons.mime.CMimeType;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.mime.MimeTypeContent;
import com.helger.commons.state.EChange;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class MimeTypeDeterminator {
    public static final IMimeType DEFAULT_MIME_TYPE = CMimeType.APPLICATION_OCTET_STREAM;
    private static final Logger s_aLogger = LoggerFactory.getLogger(MimeTypeDeterminator.class);
    private static final byte[] MIME_ID_GIF87A = new byte[]{71, 73, 70, 56, 55, 97};
    private static final byte[] MIME_ID_GIF89A = new byte[]{71, 73, 70, 56, 57, 97};
    private static final byte[] MIME_ID_JPG = new byte[]{-1, -40};
    private static final byte[] MIME_ID_PNG = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final byte[] MIME_ID_TIFF_MOTOROLLA = new byte[]{77, 77};
    private static final byte[] MIME_ID_TIFF_INTEL = new byte[]{73, 73};
    private static final byte[] MIME_ID_PSD = new byte[]{56, 66, 80, 83};
    private static final byte[] MIME_ID_PDF = new byte[]{37, 80, 68, 70};
    private static final byte[] MIME_ID_XLS = new byte[]{-48, -51, 17, -32};
    private static boolean s_bDefaultInstantiated = false;
    private final ReadWriteLock m_aRWLock = new ReentrantReadWriteLock();
    private final Set<MimeTypeContent> m_aMimeTypeContents = new HashSet<MimeTypeContent>();

    private MimeTypeDeterminator() {
        this._registerDefaultMimeTypeContents();
    }

    @MustBeLocked(value=MustBeLocked.ELockType.WRITE)
    private void _registerDefaultMimeTypeContents() {
        this.m_aMimeTypeContents.add(new MimeTypeContent(MIME_ID_GIF87A, CMimeType.IMAGE_GIF));
        this.m_aMimeTypeContents.add(new MimeTypeContent(MIME_ID_GIF89A, CMimeType.IMAGE_GIF));
        this.m_aMimeTypeContents.add(new MimeTypeContent(MIME_ID_JPG, CMimeType.IMAGE_JPG));
        this.m_aMimeTypeContents.add(new MimeTypeContent(MIME_ID_PNG, CMimeType.IMAGE_PNG));
        this.m_aMimeTypeContents.add(new MimeTypeContent(MIME_ID_TIFF_MOTOROLLA, CMimeType.IMAGE_TIFF));
        this.m_aMimeTypeContents.add(new MimeTypeContent(MIME_ID_TIFF_INTEL, CMimeType.IMAGE_TIFF));
        this.m_aMimeTypeContents.add(new MimeTypeContent(MIME_ID_PSD, CMimeType.IMAGE_PSD));
        this.m_aMimeTypeContents.add(new MimeTypeContent(MIME_ID_PDF, CMimeType.APPLICATION_PDF));
        this.m_aMimeTypeContents.add(new MimeTypeContent(MIME_ID_XLS, CMimeType.APPLICATION_MS_EXCEL));
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        arrayList.add(new byte[]{60, 0, 0, 0, 63, 0, 0, 0});
        arrayList.add(new byte[]{0, 60, 0, 0, 0, 63, 0, 0});
        arrayList.add(new byte[]{0, 0, 60, 0, 0, 0, 63, 0});
        arrayList.add(new byte[]{0, 0, 0, 60, 0, 0, 0, 63});
        arrayList.add(new byte[]{0, 60, 0, 63});
        arrayList.add(new byte[]{60, 0, 63, 0});
        arrayList.add(new byte[]{60, 63, 120, 109});
        arrayList.add(new byte[]{76, 111, -89, -108});
        for (byte[] byArray : arrayList) {
            this.registerMimeTypeContent(new MimeTypeContent(byArray, CMimeType.TEXT_XML));
        }
        for (EUnicodeBOM eUnicodeBOM : EUnicodeBOM.values()) {
            for (byte[] byArray : arrayList) {
                byte[] byArray2 = ArrayHelper.getConcatenated(eUnicodeBOM.getBytes(), byArray);
                this.registerMimeTypeContent(new MimeTypeContent(byArray2, CMimeType.TEXT_XML));
            }
        }
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static MimeTypeDeterminator getInstance() {
        s_bDefaultInstantiated = true;
        return SingletonHolder.s_aInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public EChange registerMimeTypeContent(@Nonnull MimeTypeContent mimeTypeContent) {
        ValueEnforcer.notNull(mimeTypeContent, "MimeTypeContent");
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = EChange.valueOf(this.m_aMimeTypeContents.add(mimeTypeContent));
            return eChange;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public EChange unregisterMimeTypeContent(@Nullable MimeTypeContent mimeTypeContent) {
        if (mimeTypeContent == null) {
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = EChange.valueOf(this.m_aMimeTypeContents.remove(mimeTypeContent));
            return eChange;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    @Nonnull
    @Deprecated
    public IMimeType getMimeTypeFromString(@Nullable String string, @Nonnull @Nonempty String string2) {
        return this.getMimeTypeFromBytes(string == null ? null : CharsetManager.getAsBytes(string, string2));
    }

    @Nonnull
    public IMimeType getMimeTypeFromString(@Nullable String string, @Nonnull Charset charset) {
        return this.getMimeTypeFromString(string, charset, DEFAULT_MIME_TYPE);
    }

    @Nullable
    public IMimeType getMimeTypeFromString(@Nullable String string, @Nonnull Charset charset, @Nullable IMimeType iMimeType) {
        return this.getMimeTypeFromBytes(string == null ? null : CharsetManager.getAsBytes(string, charset), iMimeType);
    }

    @Nonnull
    public IMimeType getMimeTypeFromBytes(@Nullable byte[] byArray) {
        return this.getMimeTypeFromBytes(byArray, DEFAULT_MIME_TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IMimeType getMimeTypeFromBytes(@Nullable byte[] byArray, @Nullable IMimeType iMimeType) {
        if (byArray != null && byArray.length > 0) {
            this.m_aRWLock.readLock().lock();
            try {
                for (MimeTypeContent mimeTypeContent : this.m_aMimeTypeContents) {
                    if (!mimeTypeContent.matchesBeginning(byArray)) continue;
                    IMimeType iMimeType2 = mimeTypeContent.getMimeType();
                    return iMimeType2;
                }
            }
            finally {
                this.m_aRWLock.readLock().unlock();
            }
        }
        return iMimeType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public List<MimeTypeContent> getAllMimeTypeContents() {
        this.m_aRWLock.readLock().lock();
        try {
            List<MimeTypeContent> list = ContainerHelper.newList(this.m_aMimeTypeContents);
            return list;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetCache() {
        this.m_aRWLock.writeLock().lock();
        try {
            this.m_aMimeTypeContents.clear();
            this._registerDefaultMimeTypeContents();
            if (s_aLogger.isDebugEnabled()) {
                s_aLogger.debug("Cache was reset: " + MimeTypeDeterminator.class.getName());
            }
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    private static final class SingletonHolder {
        static final MimeTypeDeterminator s_aInstance = new MimeTypeDeterminator();

        private SingletonHolder() {
        }
    }
}

