/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.name;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.ArrayHelper;
import com.helger.commons.name.IHasDisplayText;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.text.impl.TextFormatter;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class HasDisplayTextWithArgs
implements IHasDisplayText {
    private final IHasDisplayText m_aParentText;
    private final Object[] m_aArgs;

    public HasDisplayTextWithArgs(@Nonnull IHasDisplayText iHasDisplayText, Object ... objectArray) {
        this.m_aParentText = ValueEnforcer.notNull(iHasDisplayText, "ParentText");
        this.m_aArgs = ValueEnforcer.notEmpty(objectArray, "Arguments");
    }

    @Nonnull
    public IHasDisplayText getParentText() {
        return this.m_aParentText;
    }

    @Nonnull
    @ReturnsMutableCopy
    public Object[] getArgs() {
        return ArrayHelper.getCopy(this.m_aArgs);
    }

    @Override
    @Nullable
    public String getDisplayText(@Nonnull Locale locale) {
        String string = this.m_aParentText.getDisplayText(locale);
        return TextFormatter.getFormattedText(string, this.m_aArgs);
    }

    public String toString() {
        return new ToStringGenerator(this).append("parentText", this.m_aParentText).append("args", this.m_aArgs).toString();
    }
}

