/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.parent.utils;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.hierarchy.IHierarchyWalkerCallback;
import com.helger.commons.parent.IChildrenProvider;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ChildrenProviderWalker<CHILDTYPE> {
    private final IChildrenProvider<CHILDTYPE> m_aChildrenProvider;
    private final IHierarchyWalkerCallback<CHILDTYPE> m_aCallback;

    public ChildrenProviderWalker(@Nonnull IChildrenProvider<CHILDTYPE> iChildrenProvider, @Nonnull IHierarchyWalkerCallback<CHILDTYPE> iHierarchyWalkerCallback) {
        this.m_aChildrenProvider = ValueEnforcer.notNull(iChildrenProvider, "ChildrenProvider");
        this.m_aCallback = ValueEnforcer.notNull(iHierarchyWalkerCallback, "Callback");
    }

    @Nonnull
    public IChildrenProvider<CHILDTYPE> getChildrenProvider() {
        return this.m_aChildrenProvider;
    }

    @Nonnull
    public IHierarchyWalkerCallback<CHILDTYPE> getCallback() {
        return this.m_aCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _walkRecursive(@Nonnull CHILDTYPE CHILDTYPE) {
        ValueEnforcer.notNull(CHILDTYPE, "Object");
        this.m_aCallback.onItemBeforeChildren(CHILDTYPE);
        if (this.m_aChildrenProvider.hasChildren(CHILDTYPE)) {
            this.m_aCallback.onLevelDown();
            try {
                for (CHILDTYPE CHILDTYPE2 : this.m_aChildrenProvider.getAllChildren(CHILDTYPE)) {
                    this._walkRecursive(CHILDTYPE2);
                }
            }
            finally {
                this.m_aCallback.onLevelUp();
            }
        }
        this.m_aCallback.onItemAfterChildren(CHILDTYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void walk() {
        this.m_aCallback.begin();
        try {
            if (this.m_aChildrenProvider.hasChildren(null)) {
                for (CHILDTYPE CHILDTYPE : this.m_aChildrenProvider.getAllChildren(null)) {
                    this._walkRecursive(CHILDTYPE);
                }
            }
        }
        finally {
            this.m_aCallback.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void walkSub(@Nonnull CHILDTYPE CHILDTYPE) {
        ValueEnforcer.notNull(CHILDTYPE, "Object");
        this.m_aCallback.begin();
        try {
            this._walkRecursive(CHILDTYPE);
        }
        finally {
            this.m_aCallback.end();
        }
    }

    public static <CHILDTYPE> void walkProvider(@Nonnull IChildrenProvider<CHILDTYPE> iChildrenProvider, @Nonnull IHierarchyWalkerCallback<CHILDTYPE> iHierarchyWalkerCallback) {
        new ChildrenProviderWalker<CHILDTYPE>(iChildrenProvider, iHierarchyWalkerCallback).walk();
    }

    public static <CHILDTYPE> void walkSubProvider(@Nonnull CHILDTYPE CHILDTYPE, @Nonnull IChildrenProvider<CHILDTYPE> iChildrenProvider, @Nonnull IHierarchyWalkerCallback<CHILDTYPE> iHierarchyWalkerCallback) {
        new ChildrenProviderWalker<CHILDTYPE>(iChildrenProvider, iHierarchyWalkerCallback).walkSub(CHILDTYPE);
    }
}

