/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.scopes.factory;

import com.helger.commons.annotations.Nonempty;
import com.helger.commons.scopes.domain.IApplicationScope;
import com.helger.commons.scopes.domain.IGlobalScope;
import com.helger.commons.scopes.domain.IRequestScope;
import com.helger.commons.scopes.domain.ISessionApplicationScope;
import com.helger.commons.scopes.domain.ISessionScope;
import com.helger.commons.scopes.factory.IScopeFactory;
import com.helger.commons.scopes.impl.ApplicationScope;
import com.helger.commons.scopes.impl.GlobalScope;
import com.helger.commons.scopes.impl.RequestScope;
import com.helger.commons.scopes.impl.SessionApplicationScope;
import com.helger.commons.scopes.impl.SessionScope;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class DefaultScopeFactory
implements IScopeFactory {
    @Override
    @Nonnull
    public IGlobalScope createGlobalScope(@Nonnull @Nonempty String string) {
        return new GlobalScope(string);
    }

    @Override
    @Nonnull
    public IApplicationScope createApplicationScope(@Nonnull @Nonempty String string) {
        return new ApplicationScope(string);
    }

    @Override
    @Nonnull
    public ISessionScope createSessionScope(@Nonnull @Nonempty String string) {
        return new SessionScope(string);
    }

    @Override
    @Nonnull
    public ISessionApplicationScope createSessionApplicationScope(@Nonnull @Nonempty String string) {
        return new SessionApplicationScope(string);
    }

    @Override
    @Nonnull
    public IRequestScope createRequestScope(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        return new RequestScope(string, string2);
    }
}

