/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.scopes.impl;

import com.helger.commons.annotations.Nonempty;
import com.helger.commons.lang.CGStringHelper;
import com.helger.commons.scopes.AbstractMapBasedScope;
import com.helger.commons.scopes.ScopeUtils;
import com.helger.commons.scopes.domain.ISessionApplicationScope;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class SessionApplicationScope
extends AbstractMapBasedScope
implements ISessionApplicationScope {
    private static final Logger s_aLogger = LoggerFactory.getLogger(SessionApplicationScope.class);

    public SessionApplicationScope(@Nonnull @Nonempty String string) {
        super(string);
        if (ScopeUtils.debugSessionApplicationScopeLifeCycle(s_aLogger)) {
            s_aLogger.info("Created session application scope '" + string + "' of class " + CGStringHelper.getClassLocalName(this), ScopeUtils.getDebugStackTrace());
        }
    }

    @Override
    public void initScope() {
    }

    @Override
    protected void preDestroy() {
        if (ScopeUtils.debugSessionApplicationScopeLifeCycle(s_aLogger)) {
            s_aLogger.info("Destroying session application scope '" + this.getID() + "' of class " + CGStringHelper.getClassLocalName(this), ScopeUtils.getDebugStackTrace());
        }
    }

    @Override
    protected void postDestroy() {
        if (ScopeUtils.debugSessionApplicationScopeLifeCycle(s_aLogger)) {
            s_aLogger.info("Destroyed session application scope '" + this.getID() + "' of class " + CGStringHelper.getClassLocalName(this), ScopeUtils.getDebugStackTrace());
        }
    }
}

