/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.scopes.mgr;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.annotations.UsedViaReflection;
import com.helger.commons.collections.ContainerHelper;
import com.helger.commons.scopes.IScope;
import com.helger.commons.scopes.domain.ISessionScope;
import com.helger.commons.scopes.singleton.GlobalSingleton;
import com.helger.commons.scopes.spi.ScopeSPIManager;
import com.helger.commons.state.EChange;
import com.helger.commons.stats.IStatisticsHandlerCounter;
import com.helger.commons.stats.StatisticsManager;
import com.helger.commons.string.StringHelper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ScopeSessionManager
extends GlobalSingleton {
    public static final boolean DEFAULT_DESTROY_ALL_SESSIONS_ON_SCOPE_END = true;
    public static final boolean DEFAULT_END_ALL_SESSIONS_ON_SCOPE_END = true;
    private static final Logger s_aLogger = LoggerFactory.getLogger(ScopeSessionManager.class);
    private static final IStatisticsHandlerCounter s_aUniqueSessionCounter = StatisticsManager.getCounterHandler(ScopeSessionManager.class.getName() + "$UNIQUE_SESSIONS");
    private static volatile ScopeSessionManager s_aInstance = null;
    private final ReadWriteLock m_aRWLock = new ReentrantReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final Map<String, ISessionScope> m_aSessionScopes = new HashMap<String, ISessionScope>();
    @GuardedBy(value="m_aRWLock")
    private final Set<String> m_aSessionsInDestruction = new HashSet<String>();
    @GuardedBy(value="m_aRWLock")
    private boolean m_bDestroyAllSessionsOnScopeEnd = true;
    @GuardedBy(value="m_aRWLock")
    private boolean m_bEndAllSessionsOnScopeEnd = true;

    @Deprecated
    @UsedViaReflection
    public ScopeSessionManager() {
    }

    @Nonnull
    public static ScopeSessionManager getInstance() {
        if (s_aInstance == null) {
            s_aInstance = ScopeSessionManager.getGlobalSingleton(ScopeSessionManager.class);
        }
        return s_aInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ISessionScope getSessionScopeOfID(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        this.m_aRWLock.readLock().lock();
        try {
            ISessionScope iSessionScope = this.m_aSessionScopes.get(string);
            return iSessionScope;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onScopeBegin(@Nonnull ISessionScope iSessionScope) {
        ValueEnforcer.notNull(iSessionScope, "SessionScope");
        String string = iSessionScope.getID();
        this.m_aRWLock.writeLock().lock();
        try {
            if (this.m_aSessionScopes.put(string, iSessionScope) != null) {
                s_aLogger.error("Overwriting session scope with ID '" + string + "'");
            }
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        iSessionScope.initScope();
        ScopeSPIManager.onSessionScopeBegin(iSessionScope);
        s_aUniqueSessionCounter.increment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onScopeEnd(@Nonnull ISessionScope iSessionScope) {
        ValueEnforcer.notNull(iSessionScope, "SessionScope");
        if (iSessionScope.isValid()) {
            String string = iSessionScope.getID();
            boolean bl = true;
            this.m_aRWLock.writeLock().lock();
            try {
                if (this.m_aSessionsInDestruction.add(string)) {
                    ISessionScope iSessionScope2 = this.m_aSessionScopes.remove(string);
                    if (iSessionScope2 != iSessionScope) {
                        s_aLogger.error("Ending an unknown session with ID '" + string + "'");
                        s_aLogger.error("  Scope to be removed: " + iSessionScope);
                        s_aLogger.error("  Removed scope:       " + iSessionScope2);
                    }
                    bl = true;
                } else {
                    s_aLogger.info("Already destructing session '" + string + "'");
                }
            }
            finally {
                this.m_aRWLock.writeLock().unlock();
            }
            if (bl) {
                try {
                    ScopeSPIManager.onSessionScopeEnd(iSessionScope);
                    iSessionScope.destroyScope();
                }
                finally {
                    this.m_aRWLock.writeLock().lock();
                    try {
                        this.m_aSessionsInDestruction.remove(string);
                    }
                    finally {
                        this.m_aRWLock.writeLock().unlock();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAnySession() {
        this.m_aRWLock.readLock().lock();
        try {
            boolean bl = !this.m_aSessionScopes.isEmpty();
            return bl;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnegative
    public int getSessionCount() {
        this.m_aRWLock.readLock().lock();
        try {
            int n = this.m_aSessionScopes.size();
            return n;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public Collection<? extends ISessionScope> getAllSessionScopes() {
        this.m_aRWLock.readLock().lock();
        try {
            List<ISessionScope> list = ContainerHelper.newList(this.m_aSessionScopes.values());
            return list;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _checkIfAnySessionsExist() {
        if (this.containsAnySession()) {
            this.m_aRWLock.writeLock().lock();
            try {
                s_aLogger.error("The following " + this.m_aSessionScopes.size() + " session scopes are left over: " + this.m_aSessionScopes.toString());
                this.m_aSessionScopes.clear();
            }
            finally {
                this.m_aRWLock.writeLock().unlock();
            }
        }
    }

    public void destroyAllSessions() {
        for (ISessionScope iSessionScope : this.getAllSessionScopes()) {
            if (!iSessionScope.selfDestruct().isContinue()) continue;
            this.onScopeEnd(iSessionScope);
        }
        this._checkIfAnySessionsExist();
    }

    private void _endAllSessionScopes() {
        for (ISessionScope iSessionScope : this.getAllSessionScopes()) {
            this.onScopeEnd(iSessionScope);
        }
        this._checkIfAnySessionsExist();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDestroyAllSessionsOnScopeEnd() {
        this.m_aRWLock.readLock().lock();
        try {
            boolean bl = this.m_bDestroyAllSessionsOnScopeEnd;
            return bl;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public EChange setDestroyAllSessionsOnScopeEnd(boolean bl) {
        this.m_aRWLock.writeLock().lock();
        try {
            if (this.m_bDestroyAllSessionsOnScopeEnd == bl) {
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            this.m_bDestroyAllSessionsOnScopeEnd = bl;
            EChange eChange = EChange.CHANGED;
            return eChange;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEndAllSessionsOnScopeEnd() {
        this.m_aRWLock.readLock().lock();
        try {
            boolean bl = this.m_bEndAllSessionsOnScopeEnd;
            return bl;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public EChange setEndAllSessionsOnScopeEnd(boolean bl) {
        this.m_aRWLock.writeLock().lock();
        try {
            if (this.m_bEndAllSessionsOnScopeEnd == bl) {
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            this.m_bEndAllSessionsOnScopeEnd = bl;
            EChange eChange = EChange.CHANGED;
            return eChange;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    @Override
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    protected void onDestroy(@Nonnull IScope iScope) {
        if (this.isDestroyAllSessionsOnScopeEnd()) {
            this.destroyAllSessions();
        } else if (this.isEndAllSessionsOnScopeEnd()) {
            this._endAllSessionScopes();
        }
        s_aInstance = null;
    }
}

