/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.scopes.singleton;

import com.helger.commons.annotations.MustImplementEqualsAndHashcode;
import com.helger.commons.scopes.AbstractSingleton;
import com.helger.commons.scopes.domain.ISessionScope;
import com.helger.commons.scopes.mgr.ScopeManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@MustImplementEqualsAndHashcode
public abstract class SessionSingleton
extends AbstractSingleton
implements Serializable {
    protected SessionSingleton() {
    }

    private void writeObject(@Nonnull ObjectOutputStream objectOutputStream) throws IOException {
        this.writeAbstractSingletonFields(objectOutputStream);
    }

    private void readObject(@Nonnull ObjectInputStream objectInputStream) throws IOException {
        this.readAbstractSingletonFields(objectInputStream);
    }

    @Nonnull
    private static ISessionScope _getStaticScope(boolean bl) {
        return ScopeManager.getSessionScope(bl);
    }

    @Nonnull
    public static final <T extends SessionSingleton> T getSessionSingleton(@Nonnull Class<T> clazz) {
        return (T)((SessionSingleton)SessionSingleton.getSingleton(SessionSingleton._getStaticScope(true), clazz));
    }

    @Nullable
    public static final <T extends SessionSingleton> T getSessionSingletonIfInstantiated(@Nonnull Class<T> clazz) {
        return (T)((SessionSingleton)SessionSingleton.getSingletonIfInstantiated(SessionSingleton._getStaticScope(false), clazz));
    }

    public static final boolean isSessionSingletonInstantiated(@Nonnull Class<? extends SessionSingleton> clazz) {
        return SessionSingleton.isSingletonInstantiated(SessionSingleton._getStaticScope(false), clazz);
    }

    @Nonnull
    public static final List<SessionSingleton> getAllSessionSingletons() {
        return SessionSingleton.getAllSingletons(SessionSingleton._getStaticScope(false), SessionSingleton.class);
    }
}

