/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.stats;

import com.helger.commons.annotations.Nonempty;
import com.helger.commons.stats.IStatisticsHandlerCounter;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class StatisticsHandlerCounter
implements IStatisticsHandlerCounter {
    private final AtomicInteger m_aInvocationCount = new AtomicInteger();
    private final AtomicLong m_aCount = new AtomicLong();

    StatisticsHandlerCounter() {
    }

    @Override
    @Nonnegative
    public int getInvocationCount() {
        return this.m_aInvocationCount.intValue();
    }

    @Override
    @CheckForSigned
    public long getCount() {
        return this.m_aCount.longValue();
    }

    @Override
    public void increment() {
        this.m_aInvocationCount.incrementAndGet();
        this.m_aCount.incrementAndGet();
    }

    @Override
    public void increment(long l) {
        this.m_aInvocationCount.incrementAndGet();
        this.m_aCount.addAndGet(l);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsString() {
        return "invocations=" + this.getInvocationCount() + ";count=" + this.getCount();
    }
}

