/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.system;

import com.helger.commons.SystemProperties;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.name.IHasDisplayName;
import com.helger.commons.system.ENewLineMode;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.LoggerFactory;

public enum EOperatingSystem implements IHasDisplayName
{
    AIX("AIX", true),
    FREEBSD("FreeBSD", true),
    HPUX("HP-UX", true),
    LINUX("Linux", true),
    MACOS("Mac OS X", true),
    SOLARIS("Solaris", true),
    WINDOWS("Windows", false),
    ZOS("z/OS", false),
    UNKNOWN("Unknown", false);

    private static volatile EOperatingSystem s_aInstance;
    private final String m_sDisplayName;
    private final boolean m_bUnixBased;

    private EOperatingSystem(String string2, boolean bl) {
        this.m_sDisplayName = string2;
        this.m_bUnixBased = bl;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getDisplayName() {
        return this.m_sDisplayName;
    }

    public boolean isUnixBased() {
        return this.m_bUnixBased;
    }

    public boolean isCurrentOS() {
        return this == EOperatingSystem.getCurrentOS();
    }

    @Nonnull
    public ENewLineMode getNewLineMode() {
        if (this == MACOS) {
            return ENewLineMode.MAC;
        }
        if (this == WINDOWS) {
            return ENewLineMode.WINDOWS;
        }
        return ENewLineMode.UNIX;
    }

    @Nonnull
    public static EOperatingSystem forName(@Nullable String string) {
        if (string == null) {
            return UNKNOWN;
        }
        String string2 = string.toLowerCase(Locale.US);
        if (string2.contains("solaris") || string2.contains("sunos")) {
            return SOLARIS;
        }
        if (string2.contains("linux")) {
            return LINUX;
        }
        if (string2.contains("hp-ux") || string2.contains("hp ux") || string2.contains("hpux")) {
            return HPUX;
        }
        if (string2.contains("aix")) {
            return AIX;
        }
        if (string2.contains("windows")) {
            return WINDOWS;
        }
        if (string2.contains("freebsd") || string2.contains("free bsd")) {
            return FREEBSD;
        }
        if (string2.contains("macos") || string2.contains("mac os")) {
            return MACOS;
        }
        if (string2.contains("z/os")) {
            return ZOS;
        }
        return UNKNOWN;
    }

    @Nonnull
    public static EOperatingSystem getCurrentOS() {
        EOperatingSystem eOperatingSystem = s_aInstance;
        if (eOperatingSystem == null) {
            String string = EOperatingSystem.getCurrentOSName();
            s_aInstance = eOperatingSystem = EOperatingSystem.forName(string);
            if (eOperatingSystem == UNKNOWN) {
                LoggerFactory.getLogger(EOperatingSystem.class).error("Failed to resolve operating system from name '" + string + "'!!!");
            }
        }
        return eOperatingSystem;
    }

    @Nullable
    public static String getCurrentOSName() {
        return SystemProperties.getOsName();
    }

    @Nullable
    public static String getCurrentOSVersion() {
        return SystemProperties.getOsVersion();
    }

    static {
        s_aInstance = null;
    }
}

