/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.text.impl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.text.IReadonlyMultiLingualText;
import com.helger.commons.text.ISimpleMultiLingualText;
import com.helger.commons.text.impl.TextProvider;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ReadonlyMultiLingualText
extends TextProvider {
    public ReadonlyMultiLingualText() {
    }

    public ReadonlyMultiLingualText(@Nonnull Locale locale, @Nonnull String string) {
        this.internalAddText(locale, string);
    }

    public ReadonlyMultiLingualText(@Nonnull Map<Locale, String> map) {
        ValueEnforcer.notNull(map, "Content");
        for (Map.Entry<Locale, String> entry : map.entrySet()) {
            this.internalAddText(entry.getKey(), entry.getValue());
        }
    }

    public ReadonlyMultiLingualText(@Nonnull ISimpleMultiLingualText iSimpleMultiLingualText) {
        ValueEnforcer.notNull(iSimpleMultiLingualText, "SimpleMLT");
        for (Locale locale : iSimpleMultiLingualText.getAllLocales()) {
            this.internalAddText(locale, iSimpleMultiLingualText.getText(locale));
        }
    }

    public ReadonlyMultiLingualText(@Nonnull IReadonlyMultiLingualText iReadonlyMultiLingualText) {
        ValueEnforcer.notNull(iReadonlyMultiLingualText, "MLT");
        for (Map.Entry<Locale, String> entry : iReadonlyMultiLingualText.getAllTexts().entrySet()) {
            this.internalAddText(entry.getKey(), entry.getValue());
        }
    }
}

