/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.tree.withid.unique;

import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.tree.withid.BasicTreeWithID;
import com.helger.commons.tree.withid.ITreeItemWithID;
import com.helger.commons.tree.withid.unique.ITreeItemWithUniqueIDFactory;
import com.helger.commons.tree.withid.unique.ITreeWithGlobalUniqueID;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class BasicTreeWithGlobalUniqueID<KEYTYPE, DATATYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, DATATYPE, ITEMTYPE>>
extends BasicTreeWithID<KEYTYPE, DATATYPE, ITEMTYPE>
implements ITreeWithGlobalUniqueID<KEYTYPE, DATATYPE, ITEMTYPE> {
    private final ITreeItemWithUniqueIDFactory<KEYTYPE, DATATYPE, ITEMTYPE> m_aFactory;

    public BasicTreeWithGlobalUniqueID(@Nonnull ITreeItemWithUniqueIDFactory<KEYTYPE, DATATYPE, ITEMTYPE> iTreeItemWithUniqueIDFactory) {
        super(iTreeItemWithUniqueIDFactory);
        this.m_aFactory = iTreeItemWithUniqueIDFactory;
    }

    @Nonnull
    protected final ITreeItemWithUniqueIDFactory<KEYTYPE, DATATYPE, ITEMTYPE> getFactory() {
        return this.m_aFactory;
    }

    @Override
    public final boolean containsItemWithID(@Nullable KEYTYPE KEYTYPE) {
        return this.m_aFactory.containsItemWithDataID(KEYTYPE);
    }

    @Override
    @Nullable
    public final ITEMTYPE getItemWithID(@Nullable KEYTYPE KEYTYPE) {
        return this.m_aFactory.getItemOfDataID(KEYTYPE);
    }

    @Override
    @Nullable
    public final DATATYPE getItemDataWithID(@Nullable KEYTYPE KEYTYPE) {
        Object object = this.getItemWithID((Object)KEYTYPE);
        return object == null ? null : (DATATYPE)object.getData();
    }

    @Override
    @Nullable
    public final ITEMTYPE getChildWithID(@Nullable ITEMTYPE ITEMTYPE, @Nullable KEYTYPE KEYTYPE) {
        Object object = ITEMTYPE != null ? ITEMTYPE : this.getRootItem();
        return object.getChildItemOfDataID(KEYTYPE);
    }

    @Override
    @Nonnegative
    public final int getItemCount() {
        return this.m_aFactory.getItemCount();
    }

    @Override
    @Nonnull
    public final Collection<ITEMTYPE> getAllItems() {
        return this.m_aFactory.getAllItems();
    }

    @Override
    @Nonnull
    public final Collection<DATATYPE> getAllItemDatas() {
        return this.m_aFactory.getAllItemDatas();
    }

    @Override
    @Nonnull
    public final EChange removeItemWithID(@Nullable KEYTYPE KEYTYPE) {
        Object object = this.getItemWithID((Object)KEYTYPE);
        if (object == null) {
            return EChange.UNCHANGED;
        }
        ITreeItemWithID iTreeItemWithID = (ITreeItemWithID)object.getParent();
        if (iTreeItemWithID == null) {
            throw new IllegalArgumentException("Cannot remove the root item!");
        }
        if (iTreeItemWithID.removeChild(KEYTYPE).isUnchanged()) {
            throw new IllegalStateException("Failed to remove child " + object + " from parent " + iTreeItemWithID);
        }
        return EChange.CHANGED;
    }

    @Override
    public final boolean isItemSameOrDescendant(@Nullable KEYTYPE KEYTYPE, @Nullable KEYTYPE KEYTYPE2) {
        Object object = this.getItemWithID((Object)KEYTYPE);
        if (object == null) {
            return false;
        }
        Object object2 = this.getItemWithID((Object)KEYTYPE2);
        return object2 != null && object2.isSameOrChildOf(object);
    }

    @Override
    public boolean hasChildren(@Nullable ITEMTYPE ITEMTYPE) {
        return ITEMTYPE == null ? this.getRootItem().hasChildren() : ITEMTYPE.hasChildren();
    }

    @Override
    @Nonnegative
    public int getChildCount(@Nullable ITEMTYPE ITEMTYPE) {
        return ITEMTYPE == null ? this.getRootItem().getChildCount() : ITEMTYPE.getChildCount();
    }

    @Override
    @Nullable
    public List<? extends ITEMTYPE> getAllChildren(@Nullable ITEMTYPE ITEMTYPE) {
        return ITEMTYPE == null ? this.getRootItem().getAllChildren() : ITEMTYPE.getAllChildren();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        BasicTreeWithGlobalUniqueID basicTreeWithGlobalUniqueID = (BasicTreeWithGlobalUniqueID)object;
        return this.m_aFactory.equals(basicTreeWithGlobalUniqueID.m_aFactory);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_aFactory).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("factory", this.m_aFactory).toString();
    }
}

