/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.typeconvert.impl;

import com.helger.commons.annotations.IsSPIImplementation;
import com.helger.commons.locale.LocaleCache;
import com.helger.commons.typeconvert.ITypeConverter;
import com.helger.commons.typeconvert.ITypeConverterRegistrarSPI;
import com.helger.commons.typeconvert.ITypeConverterRegistry;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
@IsSPIImplementation
public final class LocaleTypeConverterRegistrar
implements ITypeConverterRegistrarSPI {
    @Override
    public void registerTypeConverter(@Nonnull ITypeConverterRegistry iTypeConverterRegistry) {
        iTypeConverterRegistry.registerTypeConverter(String.class, Locale.class, (ITypeConverter)new TypeConverterStringLocale());
    }

    private static final class TypeConverterStringLocale
    implements ITypeConverter {
        private TypeConverterStringLocale() {
        }

        @Override
        public Locale convert(@Nonnull Object object) {
            String string = (String)object;
            if ("".equals(string)) {
                return Locale.ROOT;
            }
            return LocaleCache.getLocale(string);
        }
    }
}

