/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.vendor;

import com.helger.commons.CGlobal;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.ContainerHelper;
import com.helger.commons.email.EmailAddressUtils;
import com.helger.commons.string.StringHelper;
import com.helger.commons.url.EURLProtocol;
import com.helger.commons.url.IURLProtocol;
import com.helger.commons.url.URLProtocolRegistry;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class VendorInfo {
    public static final String DEFAULT_VENDOR_LOCATION = "Vienna, Austria, Europe, World, Milky Way, Universe";
    public static final String DEFAULT_VENDOR_NAME = "Philip Helger";
    public static final String DEFAULT_VENDOR_URL_WITHOUT_PROTOCOL = "www.helger.com";
    public static final String DEFAULT_VENDOR_URL = "http://www.helger.com";
    public static final String VENDOR_PERSON_PHILIP = "Philip Helger";
    public static final String DEFAULT_VENDOR_EMAIL_SUFFIX = "@helger.com";
    public static final String DEFAULT_VENDOR_EMAIL = "office@helger.com";
    public static final int DEFAULT_INCEPTION_YEAR = 2014;
    private static final VendorInfo s_aInstance = new VendorInfo();
    private static String s_sVendorLocation = "Vienna, Austria, Europe, World, Milky Way, Universe";
    private static int s_nInceptionYear = 2014;
    private static String s_sVendorName = "Philip Helger";
    private static String s_sVendorURLWithoutProtocol = "www.helger.com";
    private static String s_sVendorURL = "http://www.helger.com";
    private static String s_sVendorEmailSuffix = "@helger.com";
    private static String s_sVendorEmail = "office@helger.com";

    private VendorInfo() {
    }

    @Nonnull
    public static String getVendorLocation() {
        return s_sVendorLocation;
    }

    public static void setVendorLocation(@Nonnull @Nonempty String string) {
        s_sVendorLocation = ValueEnforcer.notEmpty(string, "VendorLocation");
    }

    @Nonnegative
    public static int getInceptionYear() {
        return s_nInceptionYear;
    }

    public static void setInceptionYear(@Nonnegative int n) {
        s_nInceptionYear = ValueEnforcer.isGE0(n, "InceptionYear");
    }

    @Nonnull
    public static String getVendorName() {
        return s_sVendorName;
    }

    public static void setVendorName(@Nonnull @Nonempty String string) {
        s_sVendorName = ValueEnforcer.notEmpty(string, "VendorName");
    }

    @Nonnull
    public static String getVendorURLWithoutProtocol() {
        return s_sVendorURLWithoutProtocol;
    }

    @Nonnull
    public static String getVendorURL() {
        return s_sVendorURL;
    }

    public static void setVendorURL(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "VendorURL");
        IURLProtocol iURLProtocol = URLProtocolRegistry.getInstance().getProtocol(string);
        if (iURLProtocol == null) {
            s_sVendorURLWithoutProtocol = string;
            s_sVendorURL = EURLProtocol.HTTP.getWithProtocol(string);
        } else {
            s_sVendorURLWithoutProtocol = string.substring(iURLProtocol.getProtocol().length());
            s_sVendorURL = string;
        }
    }

    @Nonnull
    public static String getVendorEmail() {
        return s_sVendorEmail;
    }

    @Nonnull
    public static String getVendorEmailSuffix() {
        return s_sVendorEmailSuffix;
    }

    public static void setVendorEmail(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "VendorEmail");
        if (!EmailAddressUtils.isValid(string)) {
            throw new IllegalArgumentException("Illegal vendor email: " + string);
        }
        s_sVendorEmail = string;
        s_sVendorEmailSuffix = StringHelper.getFromFirstIncl(string, '@');
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<String> getFileHeaderLines() {
        return ContainerHelper.newList("THIS FILE IS GENERATED - DO NOT EDIT", "", "Copyright", "", "Copyright (c) " + VendorInfo.getVendorName() + " " + VendorInfo.getInceptionYear() + " - " + CGlobal.CURRENT_YEAR, VendorInfo.getVendorURL(), "", "All Rights Reserved", "Use, duplication or disclosure restricted by " + VendorInfo.getVendorName(), "", VendorInfo.getVendorLocation() + ", " + VendorInfo.getInceptionYear() + " - " + CGlobal.CURRENT_YEAR);
    }
}

