/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.xml;

import com.helger.commons.equals.EqualsUtils;
import com.helger.commons.filter.ISerializableFilter;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.xml.XMLHelper;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.w3c.dom.Element;

@NotThreadSafe
public final class FilterElementWithNamespace
implements ISerializableFilter<Element> {
    private final String m_sNamespaceURI;

    public FilterElementWithNamespace(@Nullable String string) {
        this.m_sNamespaceURI = string;
    }

    @Nullable
    public String getNamespaceURI() {
        return this.m_sNamespaceURI;
    }

    @Override
    public boolean matchesFilter(@Nullable Element element) {
        return element != null && XMLHelper.hasNamespaceURI(element, this.m_sNamespaceURI);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        FilterElementWithNamespace filterElementWithNamespace = (FilterElementWithNamespace)object;
        return EqualsUtils.equals(this.m_sNamespaceURI, filterElementWithNamespace.m_sNamespaceURI);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sNamespaceURI).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("namespaceURI", this.m_sNamespaceURI).toString();
    }
}

