/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.xml.sax;

import com.helger.commons.CGlobal;
import com.helger.commons.annotations.CodingStyleguideUnaware;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.annotations.OverrideOnDemand;
import com.helger.commons.error.EErrorLevel;
import com.helger.commons.log.LogUtils;
import com.helger.commons.xml.sax.AbstractSAXErrorHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

@Immutable
@CodingStyleguideUnaware(value="logger too visible by purpose")
public class LoggingSAXErrorHandler
extends AbstractSAXErrorHandler {
    protected static final Logger s_aLogger = LoggerFactory.getLogger(LoggingSAXErrorHandler.class);
    private static final LoggingSAXErrorHandler s_aInstance = new LoggingSAXErrorHandler();

    public LoggingSAXErrorHandler() {
    }

    public LoggingSAXErrorHandler(@Nullable ErrorHandler errorHandler) {
        super(errorHandler);
    }

    @Nonnull
    public static LoggingSAXErrorHandler getInstance() {
        return s_aInstance;
    }

    @Nonnull
    @Nonempty
    @OverrideOnDemand
    protected String getErrorMessage(@Nonnull EErrorLevel eErrorLevel, SAXParseException sAXParseException) {
        return LoggingSAXErrorHandler.getSaxParseError(eErrorLevel, sAXParseException).getAsString(CGlobal.DEFAULT_LOCALE);
    }

    @Override
    protected void internalLog(@Nonnull EErrorLevel eErrorLevel, SAXParseException sAXParseException) {
        LogUtils.log(s_aLogger, eErrorLevel, this.getErrorMessage(eErrorLevel, sAXParseException));
    }
}

