/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.callback;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.annotations.OverrideOnDemand;
import com.helger.commons.callback.IExceptionHandler;
import com.helger.commons.error.EErrorLevel;
import com.helger.commons.error.IHasErrorLevel;
import com.helger.commons.log.LogUtils;
import com.helger.commons.mock.IMockException;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingExceptionHandler
implements IExceptionHandler<Throwable>,
IHasErrorLevel {
    private static final Logger s_aLogger = LoggerFactory.getLogger(LoggingExceptionHandler.class);
    private final EErrorLevel m_eErrorLevel;

    public LoggingExceptionHandler() {
        this(EErrorLevel.ERROR);
    }

    public LoggingExceptionHandler(@Nonnull EErrorLevel eErrorLevel) {
        this.m_eErrorLevel = ValueEnforcer.notNull(eErrorLevel, "ErrorLevel");
    }

    @Override
    @Nonnull
    public EErrorLevel getErrorLevel() {
        return this.m_eErrorLevel;
    }

    @Nonnull
    @Nonempty
    @OverrideOnDemand
    protected String getLogMessage(@Nullable Throwable throwable) {
        if (throwable == null) {
            return "An error occurred";
        }
        return "Exception occurred";
    }

    @OverrideOnDemand
    protected boolean isLogException(@Nullable Throwable throwable) {
        return !(throwable instanceof IMockException);
    }

    @Override
    public void onException(@Nullable Throwable throwable) {
        String string = this.getLogMessage(throwable);
        boolean bl = this.isLogException(throwable);
        LogUtils.log(s_aLogger, this.m_eErrorLevel, string, bl ? throwable : null);
    }

    public String toString() {
        return new ToStringGenerator(this).toString();
    }
}

