/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collections.attrs;

import com.helger.commons.annotations.ReturnsMutableCopy;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IGenericReadonlyAttributeContainer<KEYTYPE, VALUETYPE>
extends Serializable {
    @Nonnegative
    public int getAttributeCount();

    public boolean containsNoAttribute();

    public boolean containsAttribute(@Nullable KEYTYPE var1);

    @Nonnull
    @ReturnsMutableCopy
    public Map<KEYTYPE, VALUETYPE> getAllAttributes();

    @Nullable
    public VALUETYPE getAttributeObject(@Nullable KEYTYPE var1);

    @Nullable
    public <DATATYPE> DATATYPE getCastedAttribute(@Nullable KEYTYPE var1);

    @Nullable
    public <DATATYPE> DATATYPE getCastedAttribute(@Nullable KEYTYPE var1, @Nullable DATATYPE var2);

    @Nullable
    public <DATATYPE> DATATYPE getTypedAttribute(@Nullable KEYTYPE var1, @Nonnull Class<DATATYPE> var2);

    @Nullable
    public <DATATYPE> DATATYPE getTypedAttribute(@Nullable KEYTYPE var1, @Nonnull Class<DATATYPE> var2, @Nullable DATATYPE var3);

    @Nullable
    public String getAttributeAsString(@Nullable KEYTYPE var1);

    @Nullable
    public String getAttributeAsString(@Nullable KEYTYPE var1, @Nullable String var2);

    public int getAttributeAsInt(@Nullable KEYTYPE var1);

    public int getAttributeAsInt(@Nullable KEYTYPE var1, int var2);

    public long getAttributeAsLong(@Nullable KEYTYPE var1);

    public long getAttributeAsLong(@Nullable KEYTYPE var1, long var2);

    public double getAttributeAsDouble(@Nullable KEYTYPE var1);

    public double getAttributeAsDouble(@Nullable KEYTYPE var1, double var2);

    public boolean getAttributeAsBoolean(@Nullable KEYTYPE var1);

    public boolean getAttributeAsBoolean(@Nullable KEYTYPE var1, boolean var2);

    @Nullable
    public BigInteger getAttributeAsBigInteger(@Nullable KEYTYPE var1);

    @Nullable
    public BigInteger getAttributeAsBigInteger(@Nullable KEYTYPE var1, @Nullable BigInteger var2);

    @Nullable
    public BigDecimal getAttributeAsBigDecimal(@Nullable KEYTYPE var1);

    @Nullable
    public BigDecimal getAttributeAsBigDecimal(@Nullable KEYTYPE var1, @Nullable BigDecimal var2);

    @Nonnull
    public Enumeration<KEYTYPE> getAttributeNames();

    @Nonnull
    public Set<KEYTYPE> getAllAttributeNames();

    @Nonnull
    public Collection<VALUETYPE> getAllAttributeValues();
}

