/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collections.attrs;

import com.helger.commons.ICloneable;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.OverrideOnDemand;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.CollectionHelper;
import com.helger.commons.collections.attrs.AbstractGenericReadonlyAttributeContainer;
import com.helger.commons.collections.attrs.IGenericAttributeContainer;
import com.helger.commons.collections.attrs.IGenericReadonlyAttributeContainer;
import com.helger.commons.equals.EqualsUtils;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.state.EContinue;
import com.helger.commons.string.ToStringGenerator;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class MapBasedGenericAttributeContainer<KEYTYPE, VALUETYPE>
extends AbstractGenericReadonlyAttributeContainer<KEYTYPE, VALUETYPE>
implements IGenericAttributeContainer<KEYTYPE, VALUETYPE>,
ICloneable<MapBasedGenericAttributeContainer<KEYTYPE, VALUETYPE>> {
    private final Map<KEYTYPE, VALUETYPE> m_aAttrs = new HashMap<KEYTYPE, VALUETYPE>();

    public MapBasedGenericAttributeContainer() {
    }

    public MapBasedGenericAttributeContainer(@Nonnull KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE) {
        this.m_aAttrs.put(KEYTYPE, VALUETYPE);
    }

    public MapBasedGenericAttributeContainer(@Nonnull Map<? extends KEYTYPE, ? extends VALUETYPE> map) {
        ValueEnforcer.notNull(map, "Map");
        this.m_aAttrs.putAll(map);
    }

    public MapBasedGenericAttributeContainer(@Nonnull IGenericReadonlyAttributeContainer<? extends KEYTYPE, ? extends VALUETYPE> iGenericReadonlyAttributeContainer) {
        ValueEnforcer.notNull(iGenericReadonlyAttributeContainer, "Container");
        this.m_aAttrs.putAll(iGenericReadonlyAttributeContainer.getAllAttributes());
    }

    @Override
    public boolean containsAttribute(@Nullable KEYTYPE KEYTYPE) {
        return KEYTYPE != null && this.m_aAttrs.containsKey(KEYTYPE);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Map<KEYTYPE, VALUETYPE> getAllAttributes() {
        return CollectionHelper.newMap(this.m_aAttrs);
    }

    @Override
    @Nullable
    public VALUETYPE getAttributeObject(@Nullable KEYTYPE KEYTYPE) {
        return KEYTYPE == null ? null : (VALUETYPE)this.m_aAttrs.get(KEYTYPE);
    }

    @Nonnull
    @OverrideOnDemand
    protected EContinue onBeforeSetAttributeValue(@Nonnull KEYTYPE KEYTYPE, @Nonnull VALUETYPE VALUETYPE) {
        return EContinue.CONTINUE;
    }

    @Override
    @Nonnull
    public EChange setAttribute(@Nonnull KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE) {
        ValueEnforcer.notNull(KEYTYPE, "Name");
        if (VALUETYPE == null) {
            return this.removeAttribute(KEYTYPE);
        }
        if (this.onBeforeSetAttributeValue(KEYTYPE, VALUETYPE).isBreak()) {
            return EChange.UNCHANGED;
        }
        VALUETYPE VALUETYPE2 = this.m_aAttrs.put(KEYTYPE, VALUETYPE);
        return EChange.valueOf(!EqualsUtils.equals(VALUETYPE, VALUETYPE2));
    }

    @Override
    @Nonnull
    public final EChange setAttributes(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> map) {
        EChange eChange = EChange.UNCHANGED;
        if (map != null) {
            for (Map.Entry<KEYTYPE, VALUETYPE> entry : map.entrySet()) {
                eChange = eChange.or(this.setAttribute(entry.getKey(), entry.getValue()));
            }
        }
        return eChange;
    }

    @Override
    @Nonnull
    public final EChange setAttributes(@Nullable IGenericReadonlyAttributeContainer<? extends KEYTYPE, ? extends VALUETYPE> iGenericReadonlyAttributeContainer) {
        if (iGenericReadonlyAttributeContainer == null) {
            return EChange.UNCHANGED;
        }
        return this.setAttributes(iGenericReadonlyAttributeContainer.getAllAttributes());
    }

    @Nonnull
    @OverrideOnDemand
    protected EContinue onBeforeRemoveAttribute(@Nonnull KEYTYPE KEYTYPE) {
        return EContinue.CONTINUE;
    }

    @Override
    @Nonnull
    public EChange removeAttribute(@Nullable KEYTYPE KEYTYPE) {
        if (KEYTYPE == null) {
            return EChange.UNCHANGED;
        }
        if (this.onBeforeRemoveAttribute(KEYTYPE).isBreak()) {
            return EChange.UNCHANGED;
        }
        return EChange.valueOf(this.m_aAttrs.remove(KEYTYPE) != null);
    }

    @Override
    @Nonnull
    public Enumeration<KEYTYPE> getAttributeNames() {
        return CollectionHelper.getEnumeration(this.m_aAttrs.keySet());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Set<KEYTYPE> getAllAttributeNames() {
        return CollectionHelper.newSet(this.m_aAttrs.keySet());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Collection<VALUETYPE> getAllAttributeValues() {
        return CollectionHelper.newList(this.m_aAttrs.values());
    }

    @Override
    @Nonnegative
    public int getAttributeCount() {
        return this.m_aAttrs.size();
    }

    @Override
    public boolean containsNoAttribute() {
        return this.m_aAttrs.isEmpty();
    }

    @Override
    @Nonnull
    public EChange clear() {
        if (this.m_aAttrs.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aAttrs.clear();
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public MapBasedGenericAttributeContainer<KEYTYPE, VALUETYPE> getClone() {
        return new MapBasedGenericAttributeContainer<KEYTYPE, VALUETYPE>(this.m_aAttrs);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MapBasedGenericAttributeContainer mapBasedGenericAttributeContainer = (MapBasedGenericAttributeContainer)object;
        return this.m_aAttrs.equals(mapBasedGenericAttributeContainer.m_aAttrs);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append((Map)this.m_aAttrs)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("attrs", this.m_aAttrs).toString();
    }
}

