/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collections.pair;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collections.pair.IReadonlyPair;
import com.helger.commons.equals.EqualsUtils;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ReadonlyPair<DATA1TYPE, DATA2TYPE>
implements IReadonlyPair<DATA1TYPE, DATA2TYPE> {
    private final DATA1TYPE m_aFirst;
    private final DATA2TYPE m_aSecond;

    public <T2 extends DATA1TYPE, U2 extends DATA2TYPE> ReadonlyPair(@Nullable T2 T2, @Nullable U2 U2) {
        this.m_aFirst = T2;
        this.m_aSecond = U2;
    }

    public ReadonlyPair(@Nonnull IReadonlyPair<? extends DATA1TYPE, ? extends DATA2TYPE> iReadonlyPair) {
        ValueEnforcer.notNull(iReadonlyPair, "Pair");
        this.m_aFirst = iReadonlyPair.getFirst();
        this.m_aSecond = iReadonlyPair.getSecond();
    }

    @Override
    @Nullable
    public DATA1TYPE getFirst() {
        return this.m_aFirst;
    }

    @Override
    @Nullable
    public DATA2TYPE getSecond() {
        return this.m_aSecond;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ReadonlyPair readonlyPair = (ReadonlyPair)object;
        return EqualsUtils.equals(this.m_aFirst, readonlyPair.m_aFirst) && EqualsUtils.equals(this.m_aSecond, readonlyPair.m_aSecond);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aFirst).append(this.m_aSecond).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("first", this.m_aFirst).append("second", this.m_aSecond).toString();
    }

    @Nonnull
    public static <T, U> ReadonlyPair<T, U> create(@Nullable T t, @Nullable U u) {
        return new ReadonlyPair(t, u);
    }
}

