/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.compare;

import com.helger.commons.compare.AbstractComparator;
import com.helger.commons.compare.CompareUtils;
import com.helger.commons.compare.ESortOrder;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ComparatorComparableNullAware<DATATYPE extends Comparable<? super DATATYPE>>
extends AbstractComparator<DATATYPE> {
    public static final boolean DEFAULT_NULL_VALUES_COME_FIRST = true;
    private boolean m_bNullValuesComeFirst = true;

    public ComparatorComparableNullAware() {
    }

    public ComparatorComparableNullAware(@Nonnull ESortOrder eSortOrder) {
        super(eSortOrder);
    }

    public ComparatorComparableNullAware(@Nullable Comparator<? super DATATYPE> comparator) {
        super(comparator);
    }

    public ComparatorComparableNullAware(@Nonnull ESortOrder eSortOrder, @Nullable Comparator<? super DATATYPE> comparator) {
        super(eSortOrder, comparator);
    }

    public final boolean isNullValuesComeFirst() {
        return this.m_bNullValuesComeFirst;
    }

    @Nonnull
    public final ComparatorComparableNullAware<DATATYPE> setNullValuesComeFirst(boolean bl) {
        this.m_bNullValuesComeFirst = bl;
        return this;
    }

    @Override
    protected final int mainCompare(@Nullable DATATYPE DATATYPE, @Nullable DATATYPE DATATYPE2) {
        return CompareUtils.nullSafeCompare(DATATYPE, DATATYPE2, this.m_bNullValuesComeFirst);
    }
}

