/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.filter;

import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.CollectionHelper;
import com.helger.commons.filter.IFilter;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class FilterChainAND<DATATYPE>
implements IFilter<DATATYPE> {
    private final List<? extends IFilter<? super DATATYPE>> m_aFilters;

    public FilterChainAND(IFilter<? super DATATYPE> ... iFilterArray) {
        this.m_aFilters = CollectionHelper.newList(iFilterArray);
    }

    public FilterChainAND(@Nullable Iterable<? extends IFilter<? super DATATYPE>> iterable) {
        this.m_aFilters = CollectionHelper.newList(iterable);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<? extends IFilter<? super DATATYPE>> getContainedFilters() {
        return CollectionHelper.newList(this.m_aFilters);
    }

    @Override
    public boolean matchesFilter(@Nullable DATATYPE DATATYPE) {
        for (IFilter<DATATYPE> iFilter : this.m_aFilters) {
            if (iFilter.matchesFilter(DATATYPE)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        FilterChainAND filterChainAND = (FilterChainAND)object;
        return this.m_aFilters.equals(filterChainAND.m_aFilters);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aFilters)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("filters", this.m_aFilters).toString();
    }

    @Nonnull
    public static <DATATYPE> FilterChainAND<DATATYPE> create(IFilter<? super DATATYPE> ... iFilterArray) {
        return new FilterChainAND<DATATYPE>(iFilterArray);
    }

    @Nonnull
    public static <DATATYPE> FilterChainAND<DATATYPE> create(@Nullable Iterable<? extends IFilter<? super DATATYPE>> iterable) {
        return new FilterChainAND<DATATYPE>(iterable);
    }
}

