/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.idfactory;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.equals.EqualsUtils;
import com.helger.commons.idfactory.IIntIDFactory;
import com.helger.commons.idfactory.ILongIDFactory;
import com.helger.commons.idfactory.IStringIDFactory;
import com.helger.commons.idfactory.MemoryIntIDFactory;
import com.helger.commons.idfactory.MemoryLongIDFactory;
import com.helger.commons.idfactory.StringIDFromGlobalIntIDFactory;
import com.helger.commons.idfactory.StringIDFromGlobalPersistentIntIDFactory;
import com.helger.commons.state.EChange;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class GlobalIDFactory {
    public static final String DEFAULT_PREFIX = "id";
    private static final Logger s_aLogger = LoggerFactory.getLogger(GlobalIDFactory.class);
    private static final ReadWriteLock s_aRWLock = new ReentrantReadWriteLock();
    private static IIntIDFactory s_aIntIDFactory = new MemoryIntIDFactory();
    private static IIntIDFactory s_aPersistentIntIDFactory;
    private static ILongIDFactory s_aLongIDFactory;
    private static ILongIDFactory s_aPersistentLongIDFactory;
    private static IStringIDFactory s_aStringIDFactory;
    private static IStringIDFactory s_aPersistentStringIDFactory;
    private static final GlobalIDFactory s_aInstance;

    private GlobalIDFactory() {
    }

    public static boolean hasIntIDFactory() {
        return GlobalIDFactory.getIntIDFactory() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static IIntIDFactory getIntIDFactory() {
        s_aRWLock.readLock().lock();
        try {
            IIntIDFactory iIntIDFactory = s_aIntIDFactory;
            return iIntIDFactory;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static EChange setIntIDFactory(@Nullable IIntIDFactory iIntIDFactory) {
        s_aRWLock.writeLock().lock();
        try {
            if (EqualsUtils.equals(s_aIntIDFactory, iIntIDFactory)) {
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            if (s_aLogger.isInfoEnabled()) {
                s_aLogger.info("Setting in-memory int ID factory " + iIntIDFactory);
            }
            s_aIntIDFactory = iIntIDFactory;
            EChange eChange = EChange.CHANGED;
            return eChange;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    public static boolean hasPersistentIntIDFactory() {
        return GlobalIDFactory.getPersistentIntIDFactory() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static IIntIDFactory getPersistentIntIDFactory() {
        s_aRWLock.readLock().lock();
        try {
            IIntIDFactory iIntIDFactory = s_aPersistentIntIDFactory;
            return iIntIDFactory;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static EChange setPersistentIntIDFactory(@Nullable IIntIDFactory iIntIDFactory) {
        s_aRWLock.writeLock().lock();
        try {
            if (EqualsUtils.equals(s_aPersistentIntIDFactory, iIntIDFactory)) {
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            if (s_aLogger.isInfoEnabled()) {
                s_aLogger.info("Setting persistent int ID factory " + iIntIDFactory);
            }
            s_aPersistentIntIDFactory = iIntIDFactory;
            EChange eChange = EChange.CHANGED;
            return eChange;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    public static boolean hasLongIDFactory() {
        return GlobalIDFactory.getLongIDFactory() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static ILongIDFactory getLongIDFactory() {
        s_aRWLock.readLock().lock();
        try {
            ILongIDFactory iLongIDFactory = s_aLongIDFactory;
            return iLongIDFactory;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static EChange setLongIDFactory(@Nullable ILongIDFactory iLongIDFactory) {
        s_aRWLock.writeLock().lock();
        try {
            if (EqualsUtils.equals(s_aLongIDFactory, iLongIDFactory)) {
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            if (s_aLogger.isInfoEnabled()) {
                s_aLogger.info("Setting in-memory long ID factory " + iLongIDFactory);
            }
            s_aLongIDFactory = iLongIDFactory;
            EChange eChange = EChange.CHANGED;
            return eChange;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    public static boolean hasPersistentLongIDFactory() {
        return GlobalIDFactory.getPersistentLongIDFactory() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static ILongIDFactory getPersistentLongIDFactory() {
        s_aRWLock.readLock().lock();
        try {
            ILongIDFactory iLongIDFactory = s_aPersistentLongIDFactory;
            return iLongIDFactory;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static EChange setPersistentLongIDFactory(@Nullable ILongIDFactory iLongIDFactory) {
        s_aRWLock.writeLock().lock();
        try {
            if (EqualsUtils.equals(s_aPersistentLongIDFactory, iLongIDFactory)) {
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            if (s_aLogger.isInfoEnabled()) {
                s_aLogger.info("Setting persistent long ID factory " + iLongIDFactory);
            }
            s_aPersistentLongIDFactory = iLongIDFactory;
            EChange eChange = EChange.CHANGED;
            return eChange;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    public static boolean hasStringIDFactory() {
        return GlobalIDFactory.getStringIDFactory() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static IStringIDFactory getStringIDFactory() {
        s_aRWLock.readLock().lock();
        try {
            IStringIDFactory iStringIDFactory = s_aStringIDFactory;
            return iStringIDFactory;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static EChange setStringIDFactory(@Nullable IStringIDFactory iStringIDFactory) {
        s_aRWLock.writeLock().lock();
        try {
            if (EqualsUtils.equals(s_aStringIDFactory, iStringIDFactory)) {
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            if (s_aLogger.isInfoEnabled()) {
                s_aLogger.info("Setting in-memory string ID factory " + iStringIDFactory);
            }
            s_aStringIDFactory = iStringIDFactory;
            EChange eChange = EChange.CHANGED;
            return eChange;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    public static boolean hasPersistentStringIDFactory() {
        return GlobalIDFactory.getPersistentStringIDFactory() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static IStringIDFactory getPersistentStringIDFactory() {
        s_aRWLock.readLock().lock();
        try {
            IStringIDFactory iStringIDFactory = s_aPersistentStringIDFactory;
            return iStringIDFactory;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static EChange setPersistentStringIDFactory(@Nullable IStringIDFactory iStringIDFactory) {
        s_aRWLock.writeLock().lock();
        try {
            if (EqualsUtils.equals(s_aPersistentStringIDFactory, iStringIDFactory)) {
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            if (s_aLogger.isInfoEnabled()) {
                s_aLogger.info("Setting persistent string ID factory " + iStringIDFactory);
            }
            s_aPersistentStringIDFactory = iStringIDFactory;
            EChange eChange = EChange.CHANGED;
            return eChange;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNewIntID() {
        s_aRWLock.readLock().lock();
        try {
            if (s_aIntIDFactory == null) {
                throw new IllegalStateException("No in-memory int ID factory has been supplied!");
            }
            int n = s_aIntIDFactory.getNewID();
            return n;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNewPersistentIntID() {
        s_aRWLock.readLock().lock();
        try {
            if (s_aPersistentIntIDFactory == null) {
                throw new IllegalStateException("No persistent int ID factory has been supplied. Don't know how to create persistent IDs!");
            }
            int n = s_aPersistentIntIDFactory.getNewID();
            return n;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNewLongID() {
        s_aRWLock.readLock().lock();
        try {
            if (s_aLongIDFactory == null) {
                throw new IllegalStateException("No in-memory long ID factory has been supplied!");
            }
            long l = s_aLongIDFactory.getNewID();
            return l;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNewPersistentLongID() {
        s_aRWLock.readLock().lock();
        try {
            if (s_aPersistentLongIDFactory == null) {
                throw new IllegalStateException("No persistent long ID factory has been supplied. Don't know how to create persistent IDs!");
            }
            long l = s_aPersistentLongIDFactory.getNewID();
            return l;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static String getNewStringID() {
        s_aRWLock.readLock().lock();
        try {
            if (s_aStringIDFactory == null) {
                throw new IllegalStateException("No in-memory string ID factory has been supplied!");
            }
            String string = (String)s_aStringIDFactory.getNewID();
            return string;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static String getNewPersistentStringID() {
        s_aRWLock.readLock().lock();
        try {
            if (s_aPersistentStringIDFactory == null) {
                throw new IllegalStateException("No persistent string ID factory has been supplied!");
            }
            String string = (String)s_aPersistentStringIDFactory.getNewID();
            return string;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getBulkNewIntIDs(@Nonnegative int n) {
        ValueEnforcer.isGT0(n, "Count");
        s_aRWLock.readLock().lock();
        try {
            if (s_aIntIDFactory == null) {
                throw new IllegalStateException("No in-memory int ID factory has been supplied!");
            }
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = s_aIntIDFactory.getNewID();
            }
            int[] nArray2 = nArray;
            return nArray2;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getBulkNewPersistentIntIDs(@Nonnegative int n) {
        ValueEnforcer.isGT0(n, "Count");
        s_aRWLock.readLock().lock();
        try {
            if (s_aPersistentIntIDFactory == null) {
                throw new IllegalStateException("No persistent int ID factory has been supplied. Don't know how to create persistent IDs!");
            }
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = s_aPersistentIntIDFactory.getNewID();
            }
            int[] nArray2 = nArray;
            return nArray2;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long[] getBulkNewLongIDs(@Nonnegative int n) {
        ValueEnforcer.isGT0(n, "Count");
        s_aRWLock.readLock().lock();
        try {
            if (s_aLongIDFactory == null) {
                throw new IllegalStateException("No in-memory long ID factory has been supplied!");
            }
            long[] lArray = new long[n];
            for (int i = 0; i < n; ++i) {
                lArray[i] = s_aLongIDFactory.getNewID();
            }
            long[] lArray2 = lArray;
            return lArray2;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long[] getBulkNewPersistentLongIDs(@Nonnegative int n) {
        ValueEnforcer.isGT0(n, "Count");
        s_aRWLock.readLock().lock();
        try {
            if (s_aPersistentLongIDFactory == null) {
                throw new IllegalStateException("No persistent long ID factory has been supplied. Don't know how to create persistent IDs!");
            }
            long[] lArray = new long[n];
            for (int i = 0; i < n; ++i) {
                lArray[i] = s_aPersistentLongIDFactory.getNewID();
            }
            long[] lArray2 = lArray;
            return lArray2;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static String[] getBulkNewStringIDs(@Nonnegative int n) {
        ValueEnforcer.isGT0(n, "Count");
        s_aRWLock.readLock().lock();
        try {
            if (s_aStringIDFactory == null) {
                throw new IllegalStateException("No in-memory string ID factory has been supplied!");
            }
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = (String)s_aStringIDFactory.getNewID();
            }
            String[] stringArray2 = stringArray;
            return stringArray2;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static String[] getBulkNewPersistentStringIDs(@Nonnegative int n) {
        ValueEnforcer.isGT0(n, "Count");
        s_aRWLock.readLock().lock();
        try {
            if (s_aPersistentStringIDFactory == null) {
                throw new IllegalStateException("No persistent string ID factory has been supplied!");
            }
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = (String)s_aPersistentStringIDFactory.getNewID();
            }
            String[] stringArray2 = stringArray;
            return stringArray2;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    static {
        s_aLongIDFactory = new MemoryLongIDFactory();
        s_aStringIDFactory = new StringIDFromGlobalIntIDFactory();
        s_aPersistentStringIDFactory = new StringIDFromGlobalPersistentIntIDFactory();
        s_aInstance = new GlobalIDFactory();
    }
}

