/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.idfactory;

import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.idfactory.ILongIDFactory;
import com.helger.commons.string.ToStringGenerator;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnegative;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class MemoryStaticLongIDFactory
implements ILongIDFactory {
    public static final long INITIAL_ID = 10000L;
    private static final AtomicLong s_aID = new AtomicLong(10000L);

    @Override
    @Nonnegative
    public long getNewID() {
        return MemoryStaticLongIDFactory.getNewStaticID();
    }

    @Nonnegative
    public static long getNewStaticID() {
        return s_aID.getAndIncrement();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return object != null && this.getClass().equals(object.getClass());
    }

    public int hashCode() {
        return new HashCodeGenerator(this).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).toString();
    }
}

